/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import java.io.File;

public class CompileMIB {
    private SMIRepositoryManager repMan;

    public CompileMIB(String license, String licenseKey, String repositoryPath, String mibPath) {
        this.repMan = new SMIRepositoryManager(license, licenseKey);
        try {
            this.repMan.open(new File(repositoryPath));
            IModuleInfo[] modules = this.repMan.addModules(new File(mibPath));
            System.out.print("Compiled " + mibPath + " successfully, it contains ");
            for (int i = 0; i < modules.length; ++i) {
                modules[i].getModuleName();
                if (i + 1 >= modules.length) continue;
                System.out.print(", ");
            }
            System.out.println();
        }
        catch (SMIParseException pex) {
            if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                for (int i = 0; i < pex.getErrorList().size(); ++i) {
                    SMIParseException p = (SMIParseException)pex.getErrorList().get(i);
                    System.out.println("#" + (i + 1) + ": " + this.repMan.getErrorText(p));
                }
            } else {
                System.out.println(this.repMan.getErrorText(pex));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: CompileMIB <license> <licenseKey> <repositoryPath> <mibFile>");
            System.exit(1);
        }
        CompileMIB c = new CompileMIB(args[0], args[1], args[2], args[3]);
    }
}

