/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRepositoryManager;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.license.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public final class SMIRepositoryManager
implements IRepositoryManager,
RepositoryListener {
    private DefaultRepositoryManager repMan;
    private boolean readonly;
    private GregorianCalendar licenseExpiration;
    private byte licenseMode;
    private transient Vector repositoryListeners;

    public SMIRepositoryManager(String license, String licenseKey) {
        block4: {
            this.repMan = new DefaultRepositoryManager();
            this.readonly = true;
            this.licenseExpiration = null;
            this.licenseMode = 0;
            try {
                byte[] lic = Validate.fromHexString(license);
                if (this.validateLicense(lic, licenseKey.getBytes())) break block4;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                System.err.println("Invalid license, aborting!");
                System.exit(1);
            }
            catch (Exception ex) {
                System.err.println("Invalid license, aborting!");
                System.exit(1);
            }
        }
        this.repMan.verbose = false;
        this.repMan.addRepositoryListener(this);
    }

    private boolean validateLicense(byte[] license, byte[] licenseKey) {
        byte[] lic = Validate.decrypt(license, new String(licenseKey).toCharArray());
        if (!(lic != null && lic.length >= 7 && (lic[0] == 16 && lic[1] == 3 || lic[0] == 1 && lic[1] == 3 || lic[0] == 80 && lic[1] == 3 || lic[0] == 0 && lic[1] == 3))) {
            return false;
        }
        if (lic[0] != 1) {
            this.readonly = false;
        }
        GregorianCalendar licGC = new GregorianCalendar(2000 + lic[4], lic[5] - 1, lic[6]);
        GregorianCalendar now = new GregorianCalendar();
        if ((lic[4] != 0 || lic[5] != 0 || lic[6] != 0) && licGC.getTime().before(now.getTime())) {
            return false;
        }
        this.licenseExpiration = lic[4] == 0 && lic[5] == 0 && lic[6] == 0 ? null : licGC;
        this.licenseMode = lic[3];
        return true;
    }

    public void open(File directory) throws IOException {
        this.repMan.open(directory);
    }

    public IModuleInfo[] addModules(File file) throws SMIParseException {
        if (this.readonly) {
            return null;
        }
        return this.repMan.addModules(file);
    }

    public void addModule(IModule module) throws IOException {
        if (this.readonly) {
            return;
        }
        MIBModule m = module instanceof MIBModule ? (MIBModule)module : new MIBModule(module);
        this.repMan.saveModule(m);
    }

    public IModule[] getModules(InputStream file, ImportModuleListener listener) throws SMIParseException {
        if (this.readonly) {
            return null;
        }
        MIBRepository rep = this.repMan.createRepository(file, listener);
        IModule[] ms = new IModule[rep.moduleCount()];
        int i = 0;
        Iterator<MIBModule> modules = rep.modulesIterator();
        while (modules.hasNext()) {
            IModule m;
            ms[i] = m = (IModule)modules.next();
            ++i;
        }
        return ms;
    }

    public void checkModules(InputStream file) throws SMIParseException {
        this.repMan.checkModules(file);
    }

    public IModuleInfo[] checkModules(InputStream file, boolean lenientSyntaxCheck) throws SMIParseException {
        return this.repMan.checkModules(file, lenientSyntaxCheck);
    }

    public IModuleInfo[] getModuleInfo(File file) throws SMIParseException {
        return this.repMan.getModuleInfo(file);
    }

    public IModuleInfo[] getModuleInfo(InputStream file, String name) throws SMIParseException {
        return this.repMan.getModuleInfo(file, name);
    }

    public IModuleInfo[] getModuleInfos() throws IOException {
        return this.repMan.getModuleInfos();
    }

    public boolean removeModule(String moduleName) throws IOException {
        if (this.readonly) {
            return false;
        }
        return this.repMan.removeModule(moduleName);
    }

    public void initialize() throws IOException {
        if (!this.readonly) {
            this.repMan.initialize();
        }
    }

    public IModule[] getModules() throws IOException {
        return this.repMan.getModules();
    }

    public IModule getModule(String moduleName) throws IOException {
        return this.repMan.getModule(moduleName, true);
    }

    public String[] getModuleNames() throws IOException {
        return this.repMan.getModuleNames();
    }

    public IObject[] getObjects(String moduleName) throws IOException {
        return this.repMan.getObjects(moduleName);
    }

    public IObject[] getImportedObjects(String moduleName) throws IOException {
        return this.repMan.getImportedObjects(moduleName);
    }

    public IObject[] getImportedObjects(String moduleName, Hashtable moduleIDs) throws IOException {
        return this.repMan.getImportedObjects(moduleIDs, moduleName);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public String getErrorText(SMIParseException parseException) {
        return DefaultRepositoryManager.getErrorText(parseException);
    }

    public String getErrorText(int errorCode, String message) {
        return DefaultRepositoryManager.getErrorText(new SMIParseException(message, errorCode));
    }

    public void setParserOptions(int options) {
        this.repMan.setOptions(options);
    }

    public int getParserOptions() {
        return this.repMan.getOptions();
    }

    public File getRepositoryDirectory() {
        return this.repMan.getRepositoryDirectory();
    }

    public synchronized void removeRepositoryListener(RepositoryListener l) {
        if (this.repositoryListeners != null && this.repositoryListeners.contains(l)) {
            Vector v = (Vector)this.repositoryListeners.clone();
            v.removeElement(l);
            this.repositoryListeners = v;
        }
    }

    public synchronized void addRepositoryListener(RepositoryListener l) {
        Vector v;
        Vector vector = v = this.repositoryListeners == null ? new Vector(2) : (Vector)this.repositoryListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.repositoryListeners = v;
        }
    }

    protected void fireWriteModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            Vector listeners = this.repositoryListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RepositoryListener)listeners.elementAt(i)).writeModule(e);
            }
        }
    }

    protected void fireReadModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            Vector listeners = this.repositoryListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RepositoryListener)listeners.elementAt(i)).readModule(e);
            }
        }
    }

    protected void fireDeleteModule(RepositoryEvent e) {
        if (this.repositoryListeners != null) {
            Vector listeners = this.repositoryListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((RepositoryListener)listeners.elementAt(i)).deleteModule(e);
            }
        }
    }

    public void writeModule(RepositoryEvent e) {
        RepositoryEvent event = new RepositoryEvent(this, e.getModuleName());
        this.fireWriteModule(event);
        e.setOutputStream(event.getOutputStream());
    }

    public void readModule(RepositoryEvent e) {
        RepositoryEvent event = new RepositoryEvent(this, e.getModuleName());
        this.fireReadModule(event);
        e.setInputStream(event.getInputStream());
    }

    public void deleteModule(RepositoryEvent e) {
        RepositoryEvent event = new RepositoryEvent(this, e.getModuleName());
        this.fireDeleteModule(event);
        e.setModuleDeleted(event.isModuleDeleted());
    }

    public void setMaxErrors(int maxErrors) {
        this.repMan.setMaxErrors(maxErrors);
    }

    public int getMaxErrors() {
        return this.repMan.getMaxErrors();
    }

    public Integer createModuleID() throws IOException {
        return this.repMan.createModuleID();
    }

    public String[] listModuleNames() {
        try {
            return this.repMan.getModuleNames();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: SMIRepositoryManager <license> <key> <mibrepository-dir>");
            System.exit(1);
        }
        SMIRepositoryManager manager = new SMIRepositoryManager(args[0], args[1]);
        try {
            manager.open(new File(args[2]));
            String[] mlist = manager.listModuleNames();
            if (mlist != null) {
                System.out.println("Modules in '" + args[2] + "' are: " + Arrays.asList(mlist));
            } else {
                System.out.println("No MIB repository in '" + args[2] + "'");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

