/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class IModuleInfoSorter {
    private ModuleInfoSorter sorter = null;

    public IModuleInfoSorter(IModuleInfo[] list) {
        ModuleInfo[] infos = new ModuleInfo[list.length];
        for (int i = 0; i < list.length; ++i) {
            infos[i] = new ModuleInfo(list[i].getModuleName(), list[i].getImports());
        }
        this.sorter = new ModuleInfoSorter(infos);
        this.sorter.resetPool();
    }

    public boolean sort() {
        return this.sorter.sort();
    }

    public IModuleInfo[] getSortedList() {
        return this.sorter.getSortedList();
    }

    public IModuleInfo[] getFailedList() {
        return this.sorter.getFailedList();
    }

    public String[] getMissingModules() {
        return this.sorter.getMissingModules();
    }

    public void setPool(IModuleInfo[] poolList) {
        this.sorter.setPool((ModuleInfo[])poolList);
    }

    public void resetPool() {
        this.sorter.resetPool();
    }

    public static Vector sortModulesByImports(List modules) {
        Vector<Object> result = new Vector<Object>(modules.size() + 1);
        ModuleInfo[] list = new ModuleInfo[modules.size()];
        Hashtable<String, IModule> h = new Hashtable<String, IModule>(list.length);
        int n = 0;
        for (IModule m : modules) {
            ModuleInfo info = new ModuleInfo(m.getModuleName(), m.getImportSources());
            info.userObject = m;
            list[n] = info;
            h.put(m.getModuleName(), m);
            ++n;
        }
        Vector<ModuleInfo> pool = new Vector<ModuleInfo>();
        for (int i = 0; i < list.length; ++i) {
            String[] sources = list[i].getImports();
            for (int j = 0; j < sources.length; ++j) {
                if (h.get(sources[j]) != null) continue;
                pool.add(new ModuleInfo(sources[j], new String[0]));
            }
        }
        ModuleInfoSorter sorter = new ModuleInfoSorter(list);
        ModuleInfo[] poolModules = new ModuleInfo[pool.size()];
        pool.toArray(poolModules);
        sorter.setPool(poolModules);
        sorter.sort();
        ModuleInfo[] sorted = sorter.getSortedList();
        for (int i = 0; i < sorted.length; ++i) {
            result.add(sorted[i].userObject);
        }
        ModuleInfo[] failed = sorter.getFailedList();
        for (int i = 0; i < failed.length; ++i) {
            result.add(failed[i].userObject);
        }
        return result;
    }
}

