/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.pib.IPibModule;
import com.agentpp.smi.IEnum;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIBModule
extends MIBModule
implements IPibModule {
    public static final long serialVersionUID = 1000L;
    private List<MIBEnum> categories;

    public PIBModule(String newModuleName, Integer newModuleID) {
        super(newModuleName, newModuleID);
    }

    public void setCategories(List<MIBEnum> categories) {
        this.categories = categories;
    }

    @Override
    public List<? extends IEnum> getCategories() {
        return this.categories;
    }

    @Override
    protected void toSMIDefinitionsBegin(int mode, StringBuffer buf) {
        if (mode != 8) {
            PIBModule.addKeyWord(mode, buf, " PIB-DEFINITIONS ::= BEGIN");
        } else {
            super.toSMIDefinitionsBegin(mode, buf);
        }
    }

    @Override
    protected String toPIB(int mode, int smiversion) {
        PIBModule c = (PIBModule)this.comparable(mode);
        if (mode != 8 && smiversion < 0 && this.categories != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("\t");
            PIBModule.addKeyWord(mode, buf, "SUBJECT-CATEGORIES ");
            buf.append(" {");
            buf.append(lineSeparator);
            MIBSyntax.toSMIEnums(mode, lineSeparator, buf, c == null || c.categories == null ? null : c.categories.iterator(), this.categories);
            buf.append("\t}");
            buf.append(lineSeparator);
            return buf.toString();
        }
        return "";
    }
}

