/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBComplianceObject;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.mib.pib.PIBModule;
import com.agentpp.mib.pib.PIBObjectType;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.SMI;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBModule2PDF {
    private static final String _$4544 = "Comments";
    private static final String _$4545 = "Keywords";
    private static final String _$4546 = "Identifier";
    private static final String _$4547 = "Values";
    private static final String _$4548 = "Types";
    private static final String _$4549 = "Clauses";
    private static final String _$4550 = "Text";
    private static final int _$4551 = 160;
    private static final int _$4554 = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat _$4556 = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository _$4557;
    private Vector _$4558;
    private int _$4559 = 8;
    private int _$4560 = 2;
    private int _$4561 = 160;
    private float _$4562 = 11.0f;
    private float _$4563 = 10.0f;
    private String _$4564 = "";
    private Rectangle _$4565;
    private Date _$4566;
    private Font _$4567 = FontFactory.getFont("Courier", this._$4563, 0);
    private Hashtable _$4571 = new Hashtable();
    private boolean _$4572;
    private boolean _$4573;
    private boolean _$4574 = true;
    private boolean _$4575 = true;
    private Vector _$4576 = new Vector();
    private int _$4577 = 0;
    private boolean _$4578;

    public MIBModule2PDF(MIBRepository rep, Vector fontStyles, int tabSize) {
        this._$4557 = rep;
        this._$4558 = fontStyles;
        this._$4559 = tabSize;
        this._$4579(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this._$4567.setSize(fontSize);
    }

    private void _$4579(Vector fontStyles) {
        for (int i = 0; i < fontStyles.size(); ++i) {
            FontStyle style = (FontStyle)fontStyles.elementAt(i);
            int s = 0;
            if (style.isBold() && style.isItalic()) {
                s = 3;
            } else if (style.isBold()) {
                s = 1;
            } else if (style.isItalic()) {
                s = 2;
            }
            Font f = FontFactory.getFont(this._$4567.getFamilyname(), this._$4567.getSize(), s, style.getColor());
            this._$4571.put(style.getName(), f);
        }
    }

    private String _$4598(int num) {
        StringBuffer buf = new StringBuffer(num);
        for (int i = 0; i < num * this._$4559; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m, OutputStream os, String creator, Rectangle pageSize) throws DocumentException {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        this._$4566 = new Date();
        this._$4560 = m.getSMIVersion();
        this._$4564 = m.getModuleName();
        this._$4565 = pageSize;
        Document doc = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance(doc, os);
        doc.addAuthor(System.getProperty("user.name"));
        doc.addKeywords(m.getModuleName() + ", " + (m.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", " + "MIB specification");
        doc.addTitle(m.getModuleName());
        doc.addCreator(creator);
        this._$4615(m);
        MyPageEvents events = new MyPageEvents();
        writer.setPageEvent(events);
        doc.open();
        if (m.hasCopyrightComment()) {
            this._$4576.add(null);
            doc.add(new Paragraph(this._$4562, m.getCopyrightComment(), (Font)this._$4571.get(_$4544)));
        }
        doc.add(this._$4624("\n"));
        this._$4625(doc, m);
        if (m.hasCopyrightCommentEnd()) {
            this._$4576.add(null);
            doc.add(new Paragraph(this._$4562, m.getCopyrightCommentEnd(), (Font)this._$4571.get(_$4544)));
        }
        try {
            doc.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void _$4615(MIBModule m) {
        this._$4576 = new Vector(m.size() + 1);
        this._$4577 = 0;
    }

    private Chunk _$4629(String keyword) {
        return new Chunk(keyword, (Font)this._$4571.get(_$4545));
    }

    private Chunk _$4624(String text) {
        return new Chunk(text, this._$4567);
    }

    private Chunk _$4631(String text) {
        return new Chunk(text, (Font)this._$4571.get(_$4544));
    }

    private Chunk _$4535(String text) {
        return new Chunk(text, (Font)this._$4571.get(_$4550));
    }

    private Phrase _$4535(int ident, String lines) {
        String prefix = this._$4598(ident);
        if (lines == null) {
            return new Phrase(prefix + "\"\"", (Font)this._$4571.get(_$4550));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Phrase p = new Phrase();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                p.add(this._$4535(s));
                continue;
            }
            if (s.equals("\r")) continue;
            p.add(this._$4535(prefix + s));
        }
        return p;
    }

    private Chunk _$4639(String text) {
        return new Chunk(text, (Font)this._$4571.get(_$4549));
    }

    private Chunk _$4640(String text) {
        return new Chunk(text, (Font)this._$4571.get(_$4548));
    }

    private Chunk _$63(String value) {
        return new Chunk(value, (Font)this._$4571.get(_$4547));
    }

    private Chunk _$4641(String value) {
        return new Chunk(value, (Font)this._$4571.get(_$4546));
    }

    private Chunk _$4642(String objectName) {
        Chunk chunk = new Chunk(objectName, (Font)this._$4571.get(_$4546));
        chunk.setLocalGoto(objectName);
        return chunk;
    }

    private void _$4646(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add(this._$63(range.getUpper().toString()));
        } else {
            doc.add(this._$63(range.getLower().toString()));
            doc.add(this._$4624(".."));
            doc.add(this._$63(range.getUpper().toString()));
        }
    }

    private void _$4650(Paragraph doc, IEnum enumeration) {
        doc.add(this._$4641(enumeration.getLabel()));
        doc.add(this._$4624("("));
        doc.add(this._$63(enumeration.getValue()));
        doc.add(this._$4624(")"));
    }

    private void _$4654(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add(this._$4629("SEQUENCE OF "));
                doc.add(this._$63(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this._$4557.getObject(syn.getSyntax()) != null) {
                    doc.add(this._$4642(syn.getSyntax()));
                } else {
                    doc.add(this._$4640(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this._$4557.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add(this._$4624(" ("));
                    doc.add(this._$4629("SIZE"));
                }
                doc.add(this._$4624(" ("));
                Enumeration en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this._$4646(doc, (MIBRange)en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add(this._$4624(" | "));
                }
                doc.add(this._$4624(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add(this._$4624(")"));
            }
        }
        if (syn.hasEnums()) {
            this._$4674(doc, syn.getEnumsVector());
        }
    }

    private void _$4674(Paragraph doc, List<MIBEnum> enums) {
        doc.add(this._$4624(" {\n" + this._$4598(3)));
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum enumeration = en.next();
            this._$4650(doc, enumeration);
            if (enumeration.hasComment()) {
                if (en.hasNext()) {
                    doc.add(this._$4624(","));
                } else {
                    doc.add(this._$4624(" "));
                }
                String space = MIBObject.space(max - enumeration.toString().length() + 1);
                doc.add(this._$4624(space));
                String lines = enumeration.getComment();
                String first = enumeration.getComment();
                int suffix = lines.indexOf(10);
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                doc.add(this._$4631(this._$4598(1) + first));
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n");
                    while (st.hasMoreTokens()) {
                        doc.add(this._$4624("\n" + this._$4598(4) + MIBObject.space(max)));
                        doc.add(this._$4631(st.nextToken()));
                    }
                }
                doc.add(this._$4624("\n" + this._$4598(3)));
                continue;
            }
            if (en.hasNext()) {
                doc.add(this._$4624(",\n" + this._$4598(3)));
                continue;
            }
            doc.add(this._$4624(" "));
        }
        doc.add(this._$4624("}"));
    }

    private void _$4686(Paragraph doc, MIBObject o) {
        doc.add(this._$4624(this._$4598(1)));
        doc.add(this._$4639("STATUS      "));
        if (!o.hasStatus()) {
            doc.add(this._$4624("current"));
        } else {
            doc.add(this._$4624(o.getStatus()));
        }
        doc.add(this._$4624("\n" + this._$4598(1)));
        doc.add(this._$4639("DESCRIPTION"));
        if (!o.hasDescription()) {
            doc.add(this._$4535(" \"\"\n"));
        } else {
            doc.add(this._$4624("\n"));
            doc.add(this._$4535(2, o.getDescription()));
            doc.add(this._$4624("\n"));
        }
        if (o instanceof PIBObjectType) {
            doc.add(this._$4624(this._$4598(1)));
            doc.add(this._$4639("INSTALL-ERRORS"));
            this._$4674(doc, ((PIBObjectType)o).getInstallErrors());
            doc.add(this._$4624("\n"));
        }
        if (o.hasReference()) {
            doc.add(this._$4624(this._$4598(1)));
            doc.add(this._$4639("REFERENCE"));
            doc.add(this._$4535(2, o.getReference()));
            doc.add(this._$4624("\n"));
        }
    }

    private void _$4695(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add(this._$4624("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                if (qualified != null) {
                    doc.add(this._$4642(qualified + "." + parent.getName()));
                } else {
                    doc.add(this._$4642(parent.getName()));
                }
            }
            doc.add(this._$4624(" "));
            for (int i = oid.size() - diff; i < oid.size(); ++i) {
                String oname = null;
                if (i + 1 < oid.size()) {
                    this._$4557.getObjectName(oid.getPrefix(i + 1));
                }
                if (oname != null) {
                    doc.add(this._$4641(oname));
                    doc.add(this._$4624("("));
                    doc.add(this._$63(oid.getSubID(i)));
                    doc.add(this._$4624(")"));
                } else {
                    doc.add(this._$63(oid.getSubID(i)));
                }
                doc.add(this._$4624(" "));
            }
            doc.add(this._$4624("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add(this._$4624("{ " + oid.toString() + " }"));
        }
    }

    private void _$4705(Paragraph doc, MIBObject o, MIBObject parent) {
        MIBObject[] parents = this._$4557.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this._$4695(doc, o.getOid(), parent, null);
        } else {
            String m = this._$4557.getModuleName(parent.getModuleID());
            if (m == null) {
                this._$4695(doc, o.getOid(), parent, null);
            } else {
                this._$4695(doc, o.getOid(), parent, m);
            }
        }
    }

    private void _$4709(Paragraph doc, MIBObject o) {
        if ((this._$4561 & 0x20) > 0) {
            if ((this._$4561 & 0x400) > 0) {
                doc.add(this._$4631(" -- " + o.getPrintableOid() + " --  "));
            } else {
                doc.add(this._$4624(this._$4598(1)));
                doc.add(this._$4631("-- " + o.getPrintableOid()));
                doc.add(this._$4624("\n"));
                doc.add(this._$4624(this._$4598(1)));
            }
        } else {
            doc.add(this._$4624(this._$4598(1)));
        }
        doc.add(this._$4629("::= "));
        MIBObject parent = this._$4557.getParent(o);
        if (parent == null) {
            doc.add(this._$4624(o.getOid().toSMI()));
        } else if (o instanceof MIBModule && parent.getModuleID() == o.getModuleID()) {
            while (parent != null && parent.getModuleID() == o.getModuleID()) {
                parent = this._$4557.getParent(parent);
            }
            if (parent == null) {
                this._$4695(doc, o.getOid(), parent, null);
            } else {
                this._$4705(doc, o, parent);
            }
        } else {
            this._$4705(doc, o, parent);
        }
    }

    private void _$4714(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            if (index instanceof PIBIndexPart) {
                doc.add(this._$4639("PIB-INDEX "));
            } else {
                doc.add(this._$4639("INDEX "));
            }
        } else if (index.getType() == 3) {
            doc.add(this._$4639("EXTENDS "));
        } else {
            doc.add(this._$4639("AUGMENTS "));
        }
        doc.add(this._$4624("{\n"));
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$4624(this._$4598(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add(this._$4629("IMPLIED "));
            }
            doc.add(this._$4642(element));
            if (en.hasMoreElements()) {
                doc.add(this._$4624(",\n"));
                continue;
            }
            doc.add(this._$4624("\n"));
        }
        doc.add(this._$4624(this._$4598(1) + "}\n"));
    }

    private void _$4722(Document doc, MIBObject o) throws DocumentException {
        Paragraph para = this._$4724(doc, o);
        if (o.getType() == 0 && o.hasStatus()) {
            para.add(this._$4629(" OBJECT-IDENTITY\n"));
            this._$4686(para, o);
        } else {
            para.add(this._$4629(" OBJECT IDENTIFIER"));
        }
        para.add(this._$4624("\n"));
        this._$4709(para, o);
        doc.add(para);
    }

    private void _$4726(Document doc, MIBObjectType ot) throws DocumentException {
        Paragraph p = this._$4724(doc, ot);
        p.add(this._$4629(" OBJECT-TYPE"));
        p.add(this._$4624("\n" + this._$4598(1)));
        p.add(this._$4639("SYNTAX      "));
        this._$4654(p, ot.getSyntax());
        p.add(this._$4624("\n"));
        if (ot.hasUnits()) {
            p.add(this._$4624(this._$4598(1)));
            p.add(this._$4639("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p.add(this._$4624("\n"));
                p.add(this._$4535(2, ot.getUnits()));
            } else {
                p.add(this._$4535(ot.getUnits()));
            }
            p.add(this._$4624("\n"));
        }
        p.add(this._$4624(this._$4598(1)));
        if (ot.getAccess() != null) {
            if (this._$4560 == 1) {
                p.add(this._$4639("ACCESS      "));
            } else {
                p.add(this._$4639("MAX-ACCESS  "));
            }
            p.add(this._$4624(ot.getAccess()));
            p.add(this._$4624("\n"));
        }
        this._$4686(p, ot);
        if (ot.hasIndexPart()) {
            p.add(this._$4624(this._$4598(1)));
            this._$4714(p, ot.getIndexPart());
        }
        if (ot instanceof PIBObjectType) {
            p.add(this._$4624(this._$4598(1)));
            this._$4714(p, (MIBIndexPart)((PIBObjectType)ot).getMibIndexPart());
            if (((PIBObjectType)ot).getUniqueObjects() != null) {
                p.add(this._$4624(this._$4598(1)));
                p.add(this._$4639("UNIQUENESS  "));
                p.add("{\n");
                Iterator<String> it = ((PIBObjectType)ot).getUniqueObjects().iterator();
                while (it.hasNext()) {
                    String element = it.next();
                    doc.add(this._$4624(this._$4598(2)));
                    doc.add(this._$4642(element));
                    if (it.hasNext()) {
                        doc.add(this._$4624(",\n"));
                        continue;
                    }
                    doc.add(this._$4624("\n"));
                }
                doc.add(this._$4624(this._$4598(1) + "}\n"));
            }
        }
        if (ot.hasDefaultValue()) {
            p.add(this._$4624(this._$4598(1)));
            p.add(this._$4639("DEFVAL      "));
            p.add(this._$4624("{ "));
            p.add(this._$63(ot.getDefaultValue()));
            p.add(this._$4624(" }\n"));
        }
        this._$4709(p, ot);
        if (this._$4557 != null && ot.isTable()) {
            p.add(this._$4624("\n\n"));
            p.add(this._$4641(ot.getSyntax().getSyntax()));
            p.add(this._$4624(" ::= "));
            p.add(this._$4629("SEQUENCE"));
            p.add(this._$4624(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().iterator());
            if (ot.getTableEntriesVector().size() == 0) {
                p.add(this._$4624(this._$4598(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                p.add(this._$4624(this._$4598(2)));
                p.add(this._$4642(s));
                p.add(this._$4624(MIBObject.space(max - s.length() + 1)));
                MIBObjectType o = (MIBObjectType)this._$4557.getObject(s);
                if (o == null) continue;
                p.add(this._$4641(o.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p.add(this._$4624(",\n"));
                    continue;
                }
                p.add(this._$4624("\n" + this._$4598(1) + "}\n"));
            }
            p.add(this._$4624("\n"));
        }
        doc.add(p);
    }

    private Paragraph _$4724(Document doc, MIBObject o) throws DocumentException {
        if (o.hasComment()) {
            this._$4576.add(null);
            doc.add(new Paragraph(this._$4562, this._$4631(o.getComment())));
        }
        Chunk chunk = new Chunk(o.getName(), (Font)this._$4571.get(_$4546));
        chunk.setLocalDestination(o.getName());
        this._$4576.add(o);
        Paragraph para = new Paragraph(this._$4562, "\n");
        para.add(chunk);
        para.setKeepTogether(this._$4572);
        return para;
    }

    private Phrase _$4742(int indent, Enumeration en, boolean link) {
        Phrase doc = new Phrase();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$4624(this._$4598(indent)));
            if (link) {
                doc.add(this._$4642(element));
            } else {
                doc.add(this._$4641(element));
            }
            if (en.hasMoreElements()) {
                doc.add(this._$4624(",\n"));
                continue;
            }
            doc.add(this._$4624("\n"));
        }
        return doc;
    }

    private void _$4745(Document doc, MIBNotifyType o) throws DocumentException {
        Paragraph p = this._$4724(doc, o);
        if (o.isV1Trap()) {
            p.add(this._$4629(" TRAP-TYPE"));
            p.add(this._$4624("\n" + this._$4598(1)));
            p.add(this._$4639("ENTERPRISE "));
            p.add(this._$4624(o.getEnterprise() + "\n"));
            if (o.hasVariables()) {
                p.add(this._$4624(this._$4598(1)));
                p.add(this._$4639("VARIABLES"));
                p.add(this._$4624(" {\n"));
                p.add(this._$4742(2, o.getVariablesVector().elements(), true));
                p.add(this._$4624(this._$4598(1) + "}\n"));
            }
            if (o.hasDescription()) {
                p.add(this._$4624("\n" + this._$4598(1)));
                p.add(this._$4639("DESCRIPTION "));
                p.add(this._$4624("\n"));
                if (!o.hasDescription()) {
                    p.add(this._$4535(" \"\"\n"));
                } else {
                    p.add(this._$4624("\n"));
                    p.add(this._$4535(2, o.getDescription()));
                    p.add(this._$4624("\n"));
                }
            }
        } else {
            p.add(this._$4639(" NOTIFICATION-TYPE"));
            p.add(this._$4624("\n"));
            if (o.hasVariables()) {
                p.add(this._$4624(this._$4598(1)));
                p.add(this._$4639("OBJECTS"));
                p.add(this._$4624(" {\n"));
                p.add(this._$4742(2, o.getVariablesVector().elements(), true));
                p.add(this._$4624(this._$4598(1) + "}\n"));
            }
            this._$4686(p, o);
        }
        if (o.isV1Trap()) {
            try {
                p.add(this._$4624(" ::= "));
                p.add(this._$63("" + o.getOid().getLastSubID()));
                p.add(this._$4624("\n"));
            }
            catch (ObjectIDFormatException oex) {}
        } else {
            this._$4709(p, o);
        }
        doc.add(p);
    }

    private void _$4752(Document doc, MIBGroup o) throws DocumentException {
        Paragraph p = this._$4724(doc, o);
        p.add(this._$4629(" " + SMI.ENTRY_TYPES[o.getType()]));
        p.add(this._$4624("\n"));
        if (o.getType() == 7) {
            p.add(this._$4624(this._$4598(1)));
            p.add(this._$4639("NOTIFICATIONS"));
            p.add(this._$4624(" {\n"));
        } else {
            p.add(this._$4624(this._$4598(1)));
            p.add(this._$4639("OBJECTS"));
            p.add(this._$4624(" {\n"));
        }
        p.add(this._$4742(2, o.getObjectsVector().elements(), true));
        p.add(this._$4624(this._$4598(1) + "}\n"));
        this._$4686(p, o);
        this._$4709(p, o);
        doc.add(p);
    }

    private void _$4756(Paragraph p, MIBVariation o) {
        p.add(this._$4624(this._$4598(1)));
        if (o instanceof MIBException) {
            p.add(this._$4639("OBJECT         "));
        } else {
            p.add(this._$4639("VARIATION      "));
        }
        p.add(this._$4624(o.getVariation()));
        if (o.hasSyntax()) {
            p.add(this._$4624("\n" + this._$4598(1) + "  "));
            p.add(this._$4639("SYNTAX       "));
            this._$4654(p, o.getSyntax());
        }
        if (o.hasWriteSyntax()) {
            p.add(this._$4624("\n" + this._$4598(1) + "  "));
            p.add(this._$4639("WRITE-SYNTAX "));
            this._$4654(p, o.getWriteSyntax());
        }
        if (o.hasAccess()) {
            p.add(this._$4624("\n" + this._$4598(1) + "  "));
            if (o instanceof MIBException) {
                if (o instanceof PIBComplianceObject) {
                    p.add(this._$4639("PIB-MIN-ACCESS "));
                } else {
                    p.add(this._$4639("MIN-ACCESS   "));
                }
            } else {
                p.add(this._$4639("ACCESS       "));
            }
            p.add(this._$4624(o.getAccess()));
        }
        if (o.hasCreationRequires()) {
            p.add(this._$4624("\n" + this._$4598(1) + "  "));
            p.add(this._$4639("CREATION-REQUIRES"));
            p.add(this._$4624(" {\n"));
            p.add(this._$4742(3, o.getCreationRequiresVector().elements(), false));
            p.add(this._$4624(" }"));
        }
        if (o.hasDefaultValue()) {
            p.add(this._$4624("\n" + this._$4598(1) + "  "));
            p.add(this._$4639("DEFVAL       "));
            p.add(this._$4624(" { "));
            p.add(this._$4624(o.getDefval()));
            p.add(this._$4624(" }"));
        }
        p.add(this._$4624("\n" + this._$4598(1) + "  "));
        p.add(this._$4639("DESCRIPTION "));
        if (o.getDescription() != null) {
            p.add(this._$4624("\n"));
            p.add(this._$4535(2, o.getDescription()));
        } else {
            p.add(this._$4535("\"\""));
        }
        p.add(this._$4624("\n"));
    }

    private void _$4765(Paragraph p, MIBComplianceModule o) {
        p.add(this._$4624(this._$4598(1)));
        p.add(this._$4639("MODULE "));
        if (o.hasModuleName()) {
            p.add(this._$4641(o.getModuleName()));
        }
        p.add(this._$4624("\n"));
        if (o.hasMandatory()) {
            p.add(this._$4624(this._$4598(1)));
            p.add(this._$4639("MANDATORY-GROUPS"));
            p.add(this._$4624(" {\n"));
            p.add(this._$4742(3, o.getMandatoryVector().elements(), false));
            p.add(this._$4624(this._$4598(1) + "}\n"));
        }
        if (o.hasVariations()) {
            Enumeration en = o.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$4756(p, v);
            }
        }
    }

    private void _$4771(Document doc, MIBCompliance o) throws DocumentException {
        if (this._$4560 > 1) {
            Paragraph p = this._$4724(doc, o);
            p.add(this._$4629(" MODULE-COMPLIANCE"));
            p.add(this._$4624("\n"));
            this._$4686(p, o);
            Enumeration en = o.getModules().elements();
            while (en.hasMoreElements()) {
                this._$4765(p, (MIBComplianceModule)en.nextElement());
            }
            this._$4709(p, o);
            doc.add(p);
        }
    }

    private void _$4773(Paragraph p, MIBSupportedModule o) {
        p.add(this._$4624("\n\n" + this._$4598(1)));
        p.add(this._$4639("SUPPORTS "));
        p.add(this._$4624(o.getSupports()));
        p.add(this._$4624("\n" + this._$4598(1)));
        p.add(this._$4639("INCLUDES"));
        p.add(this._$4624(" {\n"));
        p.add(this._$4742(2, o.getIncludes().elements(), false));
        p.add(this._$4624(this._$4598(1) + "}\n"));
        if (o.hasVariations()) {
            Enumeration en = o.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$4756(p, v);
            }
        }
    }

    private void _$4776(Document doc, MIBAgentCaps o) throws DocumentException {
        if (this._$4560 > 1) {
            Paragraph p = this._$4724(doc, o);
            p.setKeepTogether(false);
            p.add(this._$4629(" AGENT-CAPABILITIES"));
            p.add(this._$4624("\n\n" + this._$4598(1)));
            p.add(this._$4639("PRODUCT-RELEASE"));
            p.add(this._$4624("\n"));
            p.add(this._$4535(2, o.getProductRelease()));
            p.add(this._$4624("\n"));
            this._$4686(p, o);
            Enumeration en = o.getModules().elements();
            while (en.hasMoreElements()) {
                this._$4773(p, (MIBSupportedModule)en.nextElement());
            }
            this._$4709(p, o);
            doc.add(p);
        }
    }

    private void _$4778(Document doc, MIBTextualConvention o) throws DocumentException {
        Paragraph p = this._$4724(doc, o);
        if (!o.hasStatus() || SMI.statusType(o.getStatus()) == 0) {
            p.add(this._$4624(" ::= "));
            this._$4654(p, o.getSyntax());
        } else {
            p.add(this._$4624(" ::= "));
            p.add(this._$4629("TEXTUAL-CONVENTION"));
            p.add(this._$4624("\n"));
            if (o.hasDisplayHint()) {
                p.add(this._$4624(this._$4598(1)));
                p.add(this._$4639("DISPLAY-HINT "));
                p.add(this._$4535(o.getDisplayHint()));
                p.add(this._$4624("\n"));
            }
            this._$4686(p, o);
            p.add(this._$4624(this._$4598(1)));
            p.add(this._$4639("SYNTAX      "));
            this._$4654(p, o.getSyntax());
        }
        doc.add(p);
    }

    private void writeObject(Document doc, MIBObject o) throws DocumentException {
        if (o instanceof MIBObjectType) {
            this._$4726(doc, (MIBObjectType)o);
        } else if (o instanceof MIBTextualConvention) {
            this._$4778(doc, (MIBTextualConvention)o);
        } else if (o instanceof MIBNotifyType) {
            this._$4745(doc, (MIBNotifyType)o);
        } else if (o instanceof MIBGroup) {
            this._$4752(doc, (MIBGroup)o);
        } else if (o instanceof MIBCompliance) {
            this._$4771(doc, (MIBCompliance)o);
        } else if (o instanceof MIBAgentCaps) {
            this._$4776(doc, (MIBAgentCaps)o);
        } else {
            this._$4722(doc, o);
        }
    }

    private void _$4783(Document doc, MIBModule m) throws DocumentException {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this._$4561));
        Enumeration en = m.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o : orderedObjects.values()) {
            if (!(o instanceof MIBModule)) {
                this.writeObject(doc, o);
                continue;
            }
            if (!(o instanceof MIBModule) || m.getSMIVersion() != 1 || !o.getOid().isValid()) continue;
            this.writeObject(doc, o);
        }
    }

    private Chunk _$4788(String moduleName, String objectName) {
        Chunk anchor;
        if (moduleName != null) {
            anchor = new Chunk(moduleName + "." + objectName, (Font)this._$4571.get(_$4546));
            anchor.setLocalDestination(moduleName + "." + objectName);
        } else {
            anchor = new Chunk(objectName, (Font)this._$4571.get(_$4546));
            anchor.setLocalDestination(objectName);
        }
        return anchor;
    }

    private void _$4790(Paragraph doc, MIBImport imports) {
        Enumeration en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add(this._$4624(this._$4598(1)));
            String name = en.nextElement().toString();
            MIBObject[] o = this._$4557.getObjectsByName(name);
            if (o != null && o.length > 1) {
                doc.add(this._$4788(imports.getSource(), name));
            } else {
                doc.add(this._$4788(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add(this._$4624(",\n"));
        }
        doc.add(this._$4624("\n" + this._$4598(2)));
        doc.add(this._$4629("FROM "));
        doc.add(this._$4641(imports.getSource()));
        if (imports.hasComment()) {
            doc.add(this._$4624(this._$4598(2)));
            doc.add(this._$4631(imports.getComment()));
        }
    }

    private void _$4794(Document doc, MIBModule o) throws DocumentException {
        if (this._$4560 > 1 && o.getOid().size() > 0) {
            String d;
            Paragraph p = this._$4724(doc, o);
            p.add(this._$4629(" MODULE-IDENTITY"));
            if (o instanceof PIBModule) {
                p.add(this._$4624("\n" + this._$4598(1)));
                p.add(this._$4639("SUBJECT-CATEGORIES {"));
                p.add(this._$4624("\n"));
                Iterator<? extends IEnum> it = ((PIBModule)o).getCategories().iterator();
                while (it.hasNext()) {
                    IEnum element = it.next();
                    p.add(this._$4624(this._$4598(2)));
                    this._$4650(p, element);
                    if (it.hasNext()) {
                        p.add(this._$4624(",\n"));
                        continue;
                    }
                    p.add(this._$4624("\n"));
                }
                p.add(this._$4624(this._$4598(1) + "}\n"));
            }
            p.add(this._$4624("\n" + this._$4598(1)));
            p.add(this._$4639("LAST-UPDATED "));
            p.add(this._$4535(o.getLastUpdated()));
            if ((this._$4561 & 0x20) > 0 && (d = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o.getLastUpdated()))) != null) {
                p.add(this._$4624(this._$4598(1)));
                p.add(this._$4631("-- " + d));
            }
            p.add(this._$4624("\n" + this._$4598(1)));
            p.add(this._$4639("ORGANIZATION "));
            p.add(this._$4535(o.getOrganization()));
            p.add(this._$4624("\n" + this._$4598(1)));
            p.add(this._$4639("CONTACT-INFO"));
            p.add(this._$4624("\n"));
            p.add(this._$4535(2, o.getContactInfo()));
            p.add(this._$4624("\n" + this._$4598(1)));
            p.add(this._$4639("DESCRIPTION"));
            p.add(this._$4624("\n"));
            p.add(this._$4535(2, o.getDescription()));
            p.add(this._$4624("\n"));
            if (o.hasRevisions()) {
                Enumeration en = o.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d2;
                    MIBRevision r = (MIBRevision)en.nextElement();
                    p.add(this._$4624("\n" + this._$4598(1)));
                    p.add(this._$4639("REVISION "));
                    p.add(this._$4535(r.getRevision()));
                    if ((this._$4561 & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r.getRevision()))) != null) {
                        p.add(this._$4624(this._$4598(1)));
                        p.add(this._$4631("-- " + d2));
                    }
                    p.add(this._$4624("\n" + this._$4598(1)));
                    p.add(this._$4639("DESCRIPTION"));
                    p.add(this._$4624("\n"));
                    p.add(this._$4535(2, r.getDescription()));
                    p.add(this._$4624("\n"));
                }
            }
            this._$4709(p, o);
            doc.add(p);
        }
    }

    private void _$4625(Document doc, MIBModule m) throws DocumentException {
        this._$4576.add(m.getModuleName());
        Paragraph top = new Paragraph(this._$4562, this._$4624(m.getModuleName()));
        if (m instanceof PIBModule) {
            top.add(this._$4629(" PIB-DEFINITIONS ::= BEGIN"));
        } else {
            top.add(this._$4629(" DEFINITIONS ::= BEGIN"));
        }
        top.add(this._$4624("\n\n"));
        doc.add(top);
        if (m.hasImports()) {
            this._$4576.add("IMPORTS");
            Paragraph p = new Paragraph(this._$4562, "IMPORTS\n", (Font)this._$4571.get(_$4545));
            Enumeration en = m.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = (MIBImport)en.nextElement();
                this._$4790(p, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                p.add(this._$4624("\n"));
            }
            p.add(this._$4624(";"));
            doc.add(p);
        }
        this._$4794(doc, m);
        this._$4783(doc, m);
        doc.add(this._$4624("\n"));
        this._$4576.add("END");
        doc.add(new Paragraph("END", (Font)this._$4571.get(_$4545)));
    }

    public void setDefaultFont(Font defaultFont) {
        this._$4567 = defaultFont;
    }

    public Font getDefaultFont() {
        return this._$4567;
    }

    public void setLeading(float leading) {
        this._$4562 = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this._$4572 = keepTogether;
    }

    public boolean isKeepTogether() {
        return this._$4572;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this._$4573 = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this._$4573;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this._$4574 = outlineTree;
        if (outlineTree) {
            this._$4561 = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this._$4574;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this._$4575 = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this._$4575;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this._$4578 = displayCurrentDate;
    }

    public void setMode(int mode) {
        this._$4561 = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this._$4578;
    }

    public int getMode() {
        return this._$4561;
    }

    class MyPageEvents
    extends PdfPageEventHelper {
        PdfContentByte cb;
        PdfTemplate template;
        BaseFont bf = null;

        MyPageEvents() {
        }

        public void onParagraph(PdfWriter writer, Document document, float position) {
            try {
                PdfContentByte cb = writer.getDirectContent();
                PdfOutline root = null;
                String title = null;
                if (MIBModule2PDF.this._$4576.elementAt(MIBModule2PDF.this._$4577) == null) {
                    MIBModule2PDF.this._$4577++;
                    return;
                }
                MIBObject o = null;
                if (MIBModule2PDF.this._$4576.elementAt(MIBModule2PDF.this._$4577) instanceof MIBObject) {
                    o = (MIBObject)MIBModule2PDF.this._$4576.elementAt(MIBModule2PDF.this._$4577);
                    title = o.getName();
                    MIBObject parent = MIBModule2PDF.this._$4557.getParent(o);
                    if (parent != null) {
                        root = (PdfOutline)parent.userObject;
                    }
                } else {
                    title = MIBModule2PDF.this._$4576.elementAt(MIBModule2PDF.this._$4577).toString();
                }
                if (!MIBModule2PDF.this._$4574 || root == null) {
                    root = cb.getRootOutline().getKids().size() > 0 ? (PdfOutline)cb.getRootOutline().getKids().get(0) : cb.getRootOutline();
                }
                PdfDestination destination = new PdfDestination(2, position);
                PdfOutline outline = new PdfOutline(root, destination, title);
                if (o != null) {
                    o.userObject = outline;
                }
                MIBModule2PDF.this._$4577++;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            try {
                this.bf = BaseFont.createFont("Courier", "Cp1252", false);
                this.cb = writer.getDirectContent();
                this.template = this.cb.createTemplate(50.0f, 50.0f);
            }
            catch (DocumentException de) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (!MIBModule2PDF.this._$4573) {
                return;
            }
            int pageN = writer.getPageNumber();
            String text = "Page " + pageN + " of     ";
            float lenNum = this.bf.getWidthPoint("8888", 8.0f);
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(MIBModule2PDF.this._$4565.getWidth() - 30.0f - len, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, MIBModule2PDF.this._$4565.getWidth() - 30.0f - lenNum, 30.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(30.0f, 30.0f);
            this.cb.showText(MIBModule2PDF.this._$4564);
            this.cb.endText();
            if (MIBModule2PDF.this._$4578) {
                this.cb.beginText();
                this.cb.setFontAndSize(this.bf, 8.0f);
                String date = _$4556.format(MIBModule2PDF.this._$4566);
                len = this.bf.getWidthPoint(date, 8.0f);
                this.cb.setTextMatrix(MIBModule2PDF.this._$4565.getWidth() / 2.0f - len / 2.0f, 30.0f);
                this.cb.showText(date);
                this.cb.endText();
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

