/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.CompareResult;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.ext.SMIObject;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class MIBObject
implements Serializable,
SMIObject {
    public static final long serialVersionUID = 1000L;
    public String name = null;
    protected String descr = null;
    protected String reference = null;
    protected String status = null;
    protected ObjectID oid = null;
    public Integer moduleID = new Integer(-1);
    public transient Object userObject = null;
    private int type = 10;
    protected String asn1Comment = null;
    protected int released = 0;
    protected Integer sequenceID = null;
    protected int id;
    protected String asn1CommentInline;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");
    protected static int nextID = MIBObject.nextID();

    public MIBObject() {
        this.oid = new ObjectID();
    }

    public static final String getLineSeparator() {
        return lineSeparator;
    }

    protected static synchronized int nextID() {
        return nextID++;
    }

    public MIBObject(IObject other) {
        if (other.getObjectID() != null) {
            this.oid = new ObjectID(other.getPrintableOid());
        }
        this.name = other.getName();
        if (other.hasDescription()) {
            this.descr = other.getDescription();
        }
        if (other.hasReference()) {
            this.reference = other.getReference();
        }
        if (other.hasStatus()) {
            this.status = other.getStatus();
        }
        this.moduleID = new Integer(other.getModuleID());
        if (other instanceof MIBObject) {
            MIBObject o = (MIBObject)other;
            if (o.userObject != null) {
                this.userObject = o.userObject;
            }
            this.released = o.released;
            this.sequenceID = o.sequenceID;
            this.id = o.id;
        }
        this.type = other.getType();
        this.asn1Comment = other.getComment();
        this.setInlineComment(other.getInlineComment());
    }

    public MIBObject(String name) {
        this(new ObjectID(), name, new Integer(-1));
    }

    public MIBObject(Object moduleID) {
        this(new ObjectID(), null, new Integer(-1));
    }

    public MIBObject(ObjectID oid, String name) {
        this(oid, name, new Integer(-1));
    }

    public MIBObject(String name, Integer moduleID) {
        this(new ObjectID(), name, moduleID);
    }

    public MIBObject(ObjectID oid, String name, Integer moduleID) {
        this.moduleID = moduleID;
        this.oid = oid;
        this.name = name;
        this.type = 10;
    }

    public int compareTo(Object o) {
        MIBObject other = (MIBObject)o;
        if (this.getOid() != null) {
            return this.getOid().compareTo(other.getOid());
        }
        return this.getName().compareTo(other.getName());
    }

    public MIBObject getClone() {
        return new MIBObject(this);
    }

    public IObject getDeepClone() {
        return this.getClone();
    }

    public String getTypeString() {
        return SMI.ENTRY_TYPES[this.type];
    }

    public int getType() {
        return this.type;
    }

    public void setStatus(String status) {
        this.status = status;
        if (this.status != null && this.status.length() > 0) {
            this.type = 0;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public final Integer getModuleID() {
        return this.moduleID;
    }

    public final void setModuleID(Integer id) {
        this.moduleID = id;
    }

    public final boolean hasValidModuleID() {
        return this.moduleID >= 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String descr) {
        this.descr = descr;
    }

    public String getDescription() {
        return this.descr;
    }

    public void setDescrAsChars(Character[] d) {
        if (d != null) {
            char[] c = new char[d.length];
            for (int i = 0; i < d.length; ++i) {
                c[i] = d[i].charValue();
            }
            this.descr = new String(c);
        } else {
            this.descr = null;
        }
    }

    public final boolean hasDescription() {
        return this.descr != null;
    }

    public final boolean hasReference() {
        return this.reference != null;
    }

    public Character[] getDescrAsChars() {
        if (this.descr == null) {
            return null;
        }
        char[] dest = new char[this.descr.length()];
        this.descr.getChars(0, this.descr.length(), dest, 0);
        Character[] r = new Character[dest.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new Character(dest[i]);
        }
        return r;
    }

    public final void setReference(String ref) {
        this.reference = ref;
    }

    public final String getReference() {
        return this.reference;
    }

    public final void setOid(ObjectID oid) {
        this.oid = oid;
    }

    public final void setOid(String oid_str) {
        this.oid = new ObjectID(oid_str);
    }

    public final ObjectID getOid() {
        return this.oid;
    }

    public final IObjectID getObjectID() {
        return this.oid;
    }

    public final String getPrintableOid() {
        return this.oid.toString();
    }

    public final Integer getSequenceID() {
        return this.sequenceID;
    }

    public final boolean hasSequenceID() {
        return this.sequenceID != null;
    }

    public final void setSequenceID(Integer sequenceID) {
        this.sequenceID = sequenceID;
    }

    protected String getSMIDefBegin(int mode, String lineSeparator) {
        MIBObject c = this.comparable(mode);
        StringBuffer buf = new StringBuffer("\t");
        MIBObject.addKeyWord(mode, buf, "STATUS  ");
        if (this.status == null || this.status.length() == 0) {
            buf.append("current");
        } else if (mode == 8) {
            buf.append(SMI.convertStatusToSMIv2(this.status));
        } else {
            if (c != null && c.status != null && !c.status.equals(this.status)) {
                buf.append("<u>");
            }
            buf.append(this.status);
            if (c != null && c.status != null && !c.status.equals(this.status)) {
                buf.append("</u>");
            }
        }
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION");
        if (this.descr == null) {
            buf.append(" \"\"" + lineSeparator);
        } else {
            buf.append(lineSeparator);
            MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.descr), c == null ? null : MIBObject.formatLines("\t\t", c.descr));
            buf.append(lineSeparator);
        }
        String s = this.getSMIBeforeReference(mode, lineSeparator, c);
        if (s != null) {
            buf.append(s);
        }
        if (this.reference != null) {
            buf.append("\t");
            MIBObject.addKeyWord(mode, buf, "REFERENCE");
            buf.append(lineSeparator);
            MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.reference), c == null ? null : c.reference);
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    protected String getSMIBeforeReference(int mode, String lineSeparator, MIBObject c) {
        return null;
    }

    public static int minWhiteSpacePrefix(String lines, boolean countFirstLine) {
        int min = Integer.MAX_VALUE;
        StringTokenizer st = new StringTokenizer(lines, "\r\n");
        if (st.hasMoreTokens() && !countFirstLine) {
            st.nextToken();
        }
        block0: while (min > 0 && st.hasMoreTokens()) {
            String s = st.nextToken();
            for (int i = 0; i < s.length() && i < min; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                min = i;
                continue block0;
            }
        }
        return min;
    }

    public static String trimLines(String lines) {
        lines = MIBObject.getUnquotedString(lines);
        int min = MIBObject.minWhiteSpacePrefix(lines, false);
        StringTokenizer st = new StringTokenizer(lines, "\r\n", true);
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if ((s = MIBObject.addStringWithInternalLineSeparation(buf, s, st)) == null) continue;
            if (!first) {
                s = MIBObject.cutTrailingWhiteSpaces(s);
            }
            if (first) {
                buf.append(s.trim());
                first = false;
                continue;
            }
            if (s.length() > min) {
                buf.append(s.substring(min));
                continue;
            }
            buf.append(s);
        }
        return MIBObject.getQuotedString(buf.toString());
    }

    protected static String cutTrailingWhiteSpaces(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.substring(0, i + 1);
        }
        return "";
    }

    public static String formatLines(String prefix, String lines) {
        if (lines == null) {
            return prefix + "\"\"";
        }
        StringTokenizer st = new StringTokenizer(lines, "\n", true);
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                buf.append(s);
                continue;
            }
            buf.append(prefix + s);
        }
        return buf.toString();
    }

    public static String formatObjectRefs(int mode, String prefix, Iterator en, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        while (en.hasNext()) {
            String s = en.next().toString();
            buf.append(prefix);
            if ((mode & 4) > 0) {
                buf.append("<a href=\"#" + s + "\">" + s + "</a>");
            } else {
                buf.append(s);
            }
            if (!en.hasNext()) continue;
            buf.append(",");
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    protected String getSMIDefEnd(int mode, MIBRepository rep, String inlineComment, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        if (this.hasInlineComment()) {
            if (this.getType() == 10 && (mode & 0x20) <= 0) {
                buf.append(lineSeparator);
            }
            MIBObject.addComment(mode, buf, MIBObject.formatLines("\t", inlineComment.trim()), lineSeparator);
            buf.append(lineSeparator);
        }
        if ((mode & 0x20) > 0) {
            String c = "-- " + this.getPrintableOid();
            if ((mode & 0x400) <= 0) {
                if (!this.hasInlineComment() || !inlineComment.trim().endsWith(c)) {
                    buf.append('\t');
                    MIBObject.addComment(mode, buf, c, lineSeparator);
                    buf.append(lineSeparator);
                    buf.append('\t');
                }
            } else if (!this.hasInlineComment() || !inlineComment.trim().endsWith(c) && !inlineComment.trim().endsWith(c + " --")) {
                c = c + " --";
                MIBObject.addComment(mode, buf, c + " ", lineSeparator);
                buf.append(' ');
            } else {
                buf.append('\t');
            }
        } else {
            buf.append("\t");
        }
        MIBObject.addKeyWord(mode, buf, "::= ");
        MIBObject parent = rep.getParent(this);
        if (parent == null) {
            buf.append(this.getOid().toSMI());
        } else if (this instanceof MIBModule && parent.getModuleID() == this.getModuleID()) {
            while (parent != null && parent.getModuleID() == this.getModuleID()) {
                parent = rep.getParent(parent);
            }
            if (parent == null) {
                buf.append(this.getOid().toSMI());
            } else {
                buf.append(this.genSMIOidDef(mode, parent, rep));
            }
        } else {
            buf.append(this.genSMIOidDef(mode, parent, rep));
        }
        buf.append(lineSeparator);
        return buf.toString();
    }

    private String genSMIOidDef(int mode, MIBObject parent, MIBRepository rep) {
        MIBObject[] parents = rep.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            return this.getOid().toSMI(rep, mode, parent, null);
        }
        String m = rep.getModuleName(parent.getModuleID());
        if (m == null) {
            return this.getOid().toSMI(rep, mode, parent, null);
        }
        return this.getOid().toSMI(rep, mode, parent, m);
    }

    public static void addString(int mode, StringBuffer buf, String s, String os) {
        if ((mode & 2) > 0) {
            if (os != null && !os.equals(s)) {
                buf.append("<u>");
            }
            buf.append(s);
            if (os != null && !os.equals(s)) {
                buf.append("</u>");
            }
        } else {
            buf.append(s);
        }
    }

    public String getNavigationLink(int mode, MIBRepository rep, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        MIBObject.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        return buf.toString();
    }

    private static String needsFullQualification(MIBRepository rep, MIBObject o) {
        if (rep.getObjectsByName(o.getName()).length > 1) {
            return rep.getModuleName(o.getModuleID());
        }
        return null;
    }

    public static void addNavigationLinks(MIBObject o, int mode, StringBuffer buf, MIBRepository rep, String lineSeparator) {
        if ((mode & 0x200) > 0) {
            MIBObject next;
            MIBObject prev;
            StringBuffer nbuf = new StringBuffer();
            MIBObject parent = rep.getParent(o);
            if (parent != null) {
                nbuf.append("-- ");
                nbuf.append("Parent:   ");
                String m = MIBObject.needsFullQualification(rep, parent);
                if (m != null) {
                    MIBObject.addObjectLink(mode, nbuf, m + "." + parent.getName());
                } else {
                    MIBObject.addObjectLink(mode, nbuf, parent.getName());
                }
                nbuf.append(lineSeparator);
            }
            if ((prev = rep.getPrevObject(o.getOid())) != null) {
                nbuf.append("-- Previous: ");
                String m = MIBObject.needsFullQualification(rep, prev);
                if (m != null) {
                    MIBObject.addObjectLink(mode, nbuf, m + "." + prev.getName());
                } else {
                    MIBObject.addObjectLink(mode, nbuf, prev.getName());
                }
                MIBObject prevs = rep.getPrevSibblingObject(o.getOid());
                if (prevs != null && !prevs.getName().equals(prev.getName())) {
                    nbuf.append(" - Sibbling: ");
                    m = MIBObject.needsFullQualification(rep, prevs);
                    if (m != null) {
                        MIBObject.addObjectLink(mode, nbuf, m + "." + prevs.getName());
                    } else {
                        MIBObject.addObjectLink(mode, nbuf, prevs.getName());
                    }
                }
                nbuf.append(lineSeparator);
            }
            if ((next = rep.getNextObject(o.getOid())) != null) {
                nbuf.append("-- Next:     ");
                String m = MIBObject.needsFullQualification(rep, next);
                if (m != null) {
                    MIBObject.addObjectLink(mode, nbuf, m + "." + next.getName());
                } else {
                    MIBObject.addObjectLink(mode, nbuf, next.getName());
                }
                MIBObject nexts = rep.getNextSibblingObject(o.getOid());
                if (nexts != null && !nexts.getName().equals(next.getName())) {
                    nbuf.append(" - Sibbling: ");
                    m = MIBObject.needsFullQualification(rep, nexts);
                    if (m != null) {
                        MIBObject.addObjectLink(mode, nbuf, m + "." + nexts.getName());
                    } else {
                        MIBObject.addObjectLink(mode, nbuf, nexts.getName());
                    }
                }
                nbuf.append(lineSeparator);
            }
            buf.append(lineSeparator);
            MIBObject.addComment(mode, buf, nbuf.toString(), lineSeparator);
            buf.append(lineSeparator);
        }
    }

    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBObject c = this.comparable(mode);
        StringBuffer buf = new StringBuffer();
        MIBObject.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        if (this.hasComment()) {
            MIBObject.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        MIBObject.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
        if (this.type == 0 && this.status != null) {
            MIBObject.addKeyWord(mode, buf, " OBJECT-IDENTITY");
            buf.append(lineSeparator);
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
        } else {
            MIBObject.addKeyWord(mode, buf, " OBJECT IDENTIFIER ");
            if ((mode & 0x20) > 0) {
                buf.append(lineSeparator);
            }
        }
        buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
        return buf.toString();
    }

    public String toString() {
        return this.getName();
    }

    public void setComment(String comment) {
        this.asn1Comment = comment;
    }

    public void setInlineComment(String comment) {
        this.asn1CommentInline = comment == null || comment.trim().length() == 0 ? null : comment;
    }

    public String getComment() {
        return this.asn1Comment;
    }

    public String getInlineComment() {
        return this.asn1CommentInline;
    }

    public boolean hasComment() {
        return this.asn1Comment != null;
    }

    public boolean hasInlineComment() {
        return this.asn1CommentInline != null && this.asn1CommentInline.trim().length() > 0;
    }

    public int getReleased() {
        return this.released;
    }

    public boolean isReleased() {
        return this.released > 0;
    }

    public void setReleased(int released) {
        this.released = released;
    }

    public static String getUnquotedString(String s) {
        if (s == null || s.equals("\"\"")) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(s, "\"");
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return s;
    }

    public static String getQuotedString(String s) {
        return MIBObject.getQuotedString(s, true);
    }

    private static String addStringWithInternalLineSeparation(StringBuffer buf, String s, StringTokenizer st) {
        int index = "\r\n".indexOf(s);
        if (index >= 0) {
            buf.append("\n");
            String skip = null;
            for (int i = index; i < "\r\n".length() && st.hasMoreTokens(); ++i) {
                s = st.nextToken();
                index = "\r\n".indexOf(s);
                if (index > i) {
                    index = i;
                    s = null;
                    continue;
                }
                if (index < 0) {
                    skip = s;
                    break;
                }
                if (index == i) {
                    buf.append("\n");
                    return null;
                }
                s = null;
            }
            return s;
        }
        return s;
    }

    public static String getQuotedString(String s, boolean allowNull) {
        if (s.length() == 0) {
            if (allowNull) {
                return null;
            }
            return "\"\"";
        }
        StringTokenizer st = new StringTokenizer(s, "\r\n", true);
        StringBuffer buf = new StringBuffer(s.length() + 2);
        buf.append('\"');
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = MIBObject.addStringWithInternalLineSeparation(buf, token, st)) == null) continue;
            buf.append(token.replace('\"', '\''));
        }
        buf.append('\"');
        return buf.toString();
    }

    public static void addText(String lineSeparator, int mode, StringBuffer buf, String text) {
        MIBObject.addText(lineSeparator, mode, buf, text, null);
    }

    public static void addText(String lineSeparator, int mode, StringBuffer buf, String text, String ctext) {
        if ((mode & 2) > 0) {
            boolean diff = false;
            if (ctext != null && !ctext.equals(text)) {
                diff = true;
                buf.append("<u>");
            }
            int firstNonTab = 0;
            buf.append("<I><font color=\"#666699\">");
            if (text != null) {
                buf.append(text.substring(firstNonTab));
            }
            buf.append("</font></I>");
            if (diff) {
                buf.append("</u>");
            }
        } else {
            MIBObject.addLines(buf, text, lineSeparator);
        }
    }

    public static void addObjectRef(String moduleName, int mode, StringBuffer buf, String objectName) {
        MIBObject.addObjectRef(moduleName, mode, buf, objectName, null);
    }

    public static void addObjectRef(String moduleName, int mode, StringBuffer buf, String objectName, String cobjectName) {
        boolean diff = false;
        if (cobjectName != null && (mode & 2) > 0 && !objectName.equals(cobjectName)) {
            diff = true;
            buf.append("<u>");
        }
        if ((mode & 4) > 0) {
            if (moduleName != null) {
                buf.append("<a name=\"" + moduleName + "." + objectName + "\">" + objectName + "</a>");
            } else {
                buf.append("<a name=\"" + objectName + "\">" + objectName + "</a>");
            }
        } else {
            buf.append(objectName);
        }
        if (diff) {
            buf.append("</u>");
        }
    }

    public static void addObjectLink(int mode, StringBuffer buf, String objectName) {
        MIBObject.addObjectLink(mode, buf, objectName, null);
    }

    public static void addObjectLink(int mode, StringBuffer buf, String objectName, String cobjectName) {
        boolean diff = false;
        if (cobjectName != null && (mode & 2) > 0 && !objectName.equals(cobjectName)) {
            diff = true;
            buf.append("<u>");
        }
        if ((mode & 4) > 0) {
            buf.append("<a href=\"#" + objectName + "\">" + objectName + "</a>");
        } else {
            buf.append(objectName);
        }
        if (diff) {
            buf.append("</u>");
        }
    }

    private static void addLines(StringBuffer buf, String text, String lineSeparator) {
        if (text == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                buf.append(lineSeparator);
                continue;
            }
            buf.append(token);
        }
    }

    public static void addComment(int mode, StringBuffer buf, String comment, String lineSeparator) {
        if ((mode & 2) > 0) {
            buf.append("<font color=\"#408080\">");
            buf.append(comment);
            buf.append("</font>");
        } else {
            MIBObject.addLines(buf, comment, lineSeparator);
        }
    }

    public static void addKeyWord(int mode, StringBuffer buf, String keyWord) {
        if ((mode & 2) > 0) {
            buf.append("<strong>");
            buf.append(keyWord);
            buf.append("</strong>");
        } else {
            buf.append(keyWord);
        }
    }

    public static void addNum(int mode, StringBuffer buf, String num) {
        MIBObject.addNum(mode, buf, num, null);
    }

    public static void addNum(int mode, StringBuffer buf, String num, String cnum) {
        if ((mode & 2) > 0) {
            if (cnum != null && !num.equals(cnum)) {
                buf.append("<u>");
            }
            buf.append("<font color=\"#999999\">");
            buf.append(num);
            buf.append("</font>");
            if (cnum != null && !num.equals(cnum)) {
                buf.append("</u>");
            }
        } else {
            buf.append(num);
        }
    }

    public static void addNum(int mode, StringBuffer buf, long num) {
        MIBObject.addNum(mode, buf, "" + num);
    }

    public static int getMaxLength(Iterator en) {
        int max = 0;
        while (en.hasNext()) {
            int l = en.next().toString().length();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    public static String getFlatString(String s) {
        StringTokenizer st = new StringTokenizer(s, MIBObject.getLineSeparator() + "\t", true);
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreTokens()) {
            String nt = st.nextToken();
            if (MIBObject.getLineSeparator().indexOf(nt) >= 0) {
                buf.append(" ");
                continue;
            }
            if (nt.equals("\t")) continue;
            buf.append(nt);
        }
        return buf.toString();
    }

    public static String space(int len) {
        char[] s = new char[len];
        for (int i = 0; i < len; ++i) {
            s[i] = 32;
        }
        return new String(s);
    }

    public static void beginDiff(int mode, StringBuffer buf) {
        buf.append("<strike>");
    }

    public static void endDiff(int mode, StringBuffer buf) {
        buf.append("</strike>");
    }

    protected MIBObject comparable(int mode) {
        if ((mode & 2) > 0 && this.userObject != null && this.userObject instanceof CompareResult && ((CompareResult)this.userObject).other != null && ((CompareResult)this.userObject).other.getClass().equals(this.getClass())) {
            return ((CompareResult)this.userObject).other;
        }
        return null;
    }

    public boolean isStructural() {
        return this.getType() != 0;
    }

    public static String makeASN1Comment(String comment) {
        if (comment == null || comment.trim().length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(comment, "\n", true);
        StringBuffer c = new StringBuffer();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!s.equals("\n") && !s.trim().startsWith("--")) {
                c.append("--");
                c.append(s);
                continue;
            }
            c.append(s);
        }
        return c.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof MIBObject) {
            MIBObject other = (MIBObject)o;
            return MIBObject.saveCompare(this.moduleID, other.moduleID) && MIBObject.saveCompare(this.oid, other.oid) && MIBObject.saveCompare(this.name, other.name) && MIBObject.saveCompare(this.status, other.status) && MIBObject.saveCompare(this.descr, other.descr) && MIBObject.saveCompare(this.reference, other.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    protected static final boolean saveCompare(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public int getID() {
        return this.id;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.id = MIBObject.nextID();
        this.status = SMI.getCommonIdentifier(this.status);
    }

    public void freeUserObjects() {
        this.userObject = null;
    }
}

