/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.IImport;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.ext.SMIModule;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.Pair;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;

public class MIBModule
extends MIBObject
implements Serializable,
SMIModule {
    public static final long serialVersionUID = 1000L;
    protected String pathName = null;
    protected String moduleName;
    protected Vector revisions = null;
    protected Vector imports = null;
    protected String organization;
    protected String lastUpdated;
    protected String contactInfo;
    protected Date lastChange = null;
    protected int smiVersion = 1;
    protected String copyrightComment;
    protected String copyrightCommentEnd;
    protected transient Map objects = null;
    protected int parseMode = 0;
    protected transient int startPosition = 0;
    private static final String[] STANDARD_MIBS = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF", "RFC1155-SMI", "RFC1215"};

    public MIBModule() {
        this.objects = new Hashtable();
    }

    public MIBModule(String newModuleName, Integer newModuleID) {
        this.objects = new Hashtable();
        this.moduleName = newModuleName;
        this.moduleID = newModuleID;
    }

    public MIBModule(ObjectID oid, String name) {
        super(oid, name);
        this.objects = new Hashtable();
    }

    public MIBModule(IModule other) {
        super(other);
        this.moduleName = other.getModuleName();
        this.revisions = new Vector<IRevision>(Arrays.asList(other.getRevisions()));
        if (other.hasImports()) {
            IImport[] imp = other.getImports();
            for (int i = 0; i < imp.length; ++i) {
                this.addImport(new MIBImport(imp[i].getSource(), new Vector<String>(Arrays.asList(imp[i].getImports())), imp[i].getComment()));
            }
        }
        this.organization = other.getOrganization();
        this.lastChange = new Date();
        this.lastUpdated = other.getLastUpdated();
        this.contactInfo = other.getContactInfo();
        this.smiVersion = other.getSMIVersion();
        this.moduleID = other.getModuleID();
        this.copyrightComment = other.getCopyrightComment();
        this.copyrightCommentEnd = other.getCopyrightCommentEnd();
        this.objects = new Hashtable();
        Enumeration en = other.objects();
        while (en.hasMoreElements()) {
            IObject o = (IObject)en.nextElement();
            this.objects.put(o.getName(), o);
        }
        if (this.objects.containsKey(other.getName())) {
            this.objects.remove(other.getName());
            this.add(this);
        }
    }

    public MIBModule(MIBModule other) {
        super(other);
        this.pathName = other.pathName;
        this.moduleName = other.moduleName;
        this.revisions = other.revisions;
        if (other.hasImports()) {
            Enumeration en = other.imports.elements();
            while (en.hasMoreElements()) {
                this.addImport(new MIBImport((MIBImport)en.nextElement()));
            }
        }
        this.organization = other.organization;
        this.lastChange = new Date(other.lastChange.getTime());
        this.lastUpdated = other.lastUpdated;
        this.contactInfo = other.contactInfo;
        this.smiVersion = other.smiVersion;
        this.moduleID = other.moduleID;
        this.copyrightComment = other.copyrightComment;
        this.copyrightCommentEnd = other.copyrightCommentEnd;
        this.objects = new HashMap(other.objects);
        if (this.objects.containsKey(other.getName())) {
            this.objects.remove(other.getName());
            this.add(this);
        }
    }

    public MIBObject getClone() {
        return new MIBModule(this);
    }

    public int compareTo(Object o) {
        MIBObject other = (MIBObject)o;
        if (other instanceof MIBModule) {
            return this.getModuleName().compareTo(((MIBModule)other).getModuleName());
        }
        return super.compareTo(o);
    }

    public int size() {
        return this.objects.size();
    }

    public String getTypeString() {
        return SMI.ENTRY_TYPES[5];
    }

    public void reinit() {
        this.objects = new Hashtable();
    }

    public void add(MIBObject o) {
        this.objects.put(o.getName(), o);
    }

    public boolean remove(MIBObject o) {
        return this.objects.remove(o.getName()) != null;
    }

    public MIBObject get(ObjectID oid) {
        for (MIBObject o : this.objects.values()) {
            if (!o.getOid().equals(oid)) continue;
            return o;
        }
        return null;
    }

    public IObject getObject(String objectName) {
        return this.getObjectByName(objectName);
    }

    public IObject getObjectByOID(String oid) {
        return this.get(new ObjectID(oid));
    }

    public MIBObject getObjectByName(String objectName) {
        return (MIBObject)this.objects.get(objectName);
    }

    public int hashCode() {
        return this.moduleID.hashCode();
    }

    public Enumeration objects() {
        return new EnumerationIterator(this.objects.values().iterator());
    }

    public Iterator objectsIterator() {
        return this.objects.values().iterator();
    }

    public OrderedMap objectsByOid() {
        return this.objectsByOid(false);
    }

    public OrderedMap objectsByOid(boolean returnDuplicates) {
        Iterator iobjects = this.objects.values().iterator();
        OrderedMap omap = new OrderedMap(ObjectIDPredicate.instance, returnDuplicates);
        while (iobjects.hasNext()) {
            MIBObject o = (MIBObject)iobjects.next();
            if (o.getOid().isEmpty()) continue;
            omap.put(o.getOid(), o);
        }
        return omap;
    }

    public OrderedMap objectsByName() {
        Iterator iobjects = this.objects.values().iterator();
        OrderedMap omap = new OrderedMap(new LexicographicPredicate());
        while (iobjects.hasNext()) {
            MIBObject o = (MIBObject)iobjects.next();
            omap.put(o.getName(), o);
        }
        return omap;
    }

    public Vector getObjectsVector() {
        Vector v = new Vector(this.objects.size());
        v.addAll(this.objects.values());
        return v;
    }

    public MIBObject[] getObjects() {
        Vector v = this.getObjectsVector();
        Object[] o = new MIBObject[v.size()];
        v.copyInto(o);
        return o;
    }

    public void setObjectsVector(Vector objs) {
        this.objects = new Hashtable(objs.size());
        Enumeration en = objs.elements();
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            this.add(o);
        }
    }

    public void setModuleName(String newModuleName) {
        this.moduleName = newModuleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setFileName(String name) {
        this.pathName = name;
    }

    public String getFileName() {
        return this.pathName;
    }

    public void addImport(MIBImport imp) {
        if (this.imports == null) {
            this.imports = new Vector(5);
        }
        this.imports.addElement(imp);
    }

    public IImport[] getImports() {
        if (this.imports == null) {
            return null;
        }
        Object[] i = new MIBImport[this.imports.size()];
        this.imports.copyInto(i);
        return i;
    }

    public boolean imports(String objectName) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i = (MIBImport)en.nextElement();
            if (!i.imports(objectName)) continue;
            return true;
        }
        return false;
    }

    public boolean imports(String objectName, String moduleName) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i = (MIBImport)en.nextElement();
            if (!i.imports(objectName) || !i.getSource().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    public String[] getImportSources() {
        if (this.imports == null) {
            return new String[0];
        }
        String[] imp = new String[this.imports.size()];
        int i = 0;
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            imp[i] = ((MIBImport)en.nextElement()).getSource();
            ++i;
        }
        return imp;
    }

    public boolean importsFrom(String moduleName) {
        if (this.imports == null) {
            return false;
        }
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            if (!moduleName.equals(((MIBImport)en.nextElement()).getSource())) continue;
            return true;
        }
        return false;
    }

    public void setImports(MIBImport[] imports) {
        this.imports = MIBRepository.buildVector(imports);
    }

    public void setImportsVector(Vector v) {
        this.imports = v;
    }

    public Vector getImportsVector() {
        return this.imports;
    }

    public boolean hasImports() {
        return this.imports != null && this.imports.size() > 0;
    }

    public String toString() {
        return this.moduleName;
    }

    public boolean isUsedSyntax(MIBTextualConvention tc) {
        for (MIBObject o : this.objects.values()) {
            MIBObject ot;
            if (!(o instanceof MIBObjectType ? ((MIBObjectType)(ot = (MIBObjectType)o)).getSyntax().getSyntax().equals(tc.getName()) : o instanceof MIBTextualConvention && ((MIBTextualConvention)(ot = (MIBTextualConvention)o)).getSyntax().getSyntax().equals(tc.getName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isUsedSyntax(String syntax) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject ot;
            MIBObject o = (MIBObject)en.nextElement();
            if (o.getTypeString().equals(syntax) || o instanceof MIBObjectType && ((MIBObjectType)o).getSyntax().getSyntax().equals(syntax) || o instanceof MIBTextualConvention && ((MIBTextualConvention)o).getSyntax().getSyntax().equals(syntax)) {
                return true;
            }
            if (!(o instanceof MIBObjectType ? ((MIBObjectType)(ot = (MIBObjectType)o)).getSyntax().getSyntax().equals(syntax) : o instanceof MIBTextualConvention && ((MIBTextualConvention)(ot = (MIBTextualConvention)o)).getSyntax().getSyntax().equals(syntax))) continue;
            return true;
        }
        return false;
    }

    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBModule c = (MIBModule)this.comparable(mode);
        StringBuffer buf = new StringBuffer();
        MIBModule.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        if (this.hasComment()) {
            MIBModule.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        if (this.smiVersion != 1 && this.oid.size() > 0 || mode == 8) {
            MIBModule.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
            MIBModule.addKeyWord(mode, buf, " MODULE-IDENTITY");
            buf.append(lineSeparator);
            buf.append(this.toPIB(mode, smiversion));
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "LAST-UPDATED ");
            if (mode == 8) {
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                String d;
                MIBModule.addText(lineSeparator, mode, buf, this.lastUpdated, c == null ? null : c.lastUpdated);
                if ((mode & 0x20) > 0 && (d = MIBModule.getTimeFromUTC(MIBModule.getUnquotedString(this.lastUpdated))) != null) {
                    buf.append("\t");
                    MIBModule.addComment(mode, buf, "-- " + d, lineSeparator);
                }
            }
            buf.append(lineSeparator);
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "ORGANIZATION ");
            if (mode == 8) {
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, buf, this.organization, c == null ? null : c.organization);
            }
            buf.append(lineSeparator);
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "CONTACT-INFO");
            buf.append(lineSeparator);
            if (mode == 8) {
                buf.append("\t\t");
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, buf, MIBModule.formatLines("\t\t", this.contactInfo), c == null ? null : MIBModule.formatLines("\t\t", c.contactInfo));
            }
            buf.append(lineSeparator);
            buf.append("\t");
            MIBModule.addKeyWord(mode, buf, "DESCRIPTION");
            buf.append(lineSeparator);
            if (mode == 8) {
                buf.append("\t\t");
                MIBModule.addText(lineSeparator, mode, buf, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, buf, MIBModule.formatLines("\t\t", this.descr), c == null ? null : MIBModule.formatLines("\t\t", c.descr));
            }
            buf.append(lineSeparator);
            if (this.hasRevisions()) {
                Enumeration cen = null;
                if (c != null) {
                    cen = c.hasRevisions() ? c.revisions.elements() : new Vector().elements();
                }
                Enumeration en = this.revisions.elements();
                while (en.hasMoreElements()) {
                    MIBRevision cs = null;
                    if (cen != null) {
                        cs = cen.hasMoreElements() ? (MIBRevision)cen.nextElement() : new MIBRevision("", "");
                    }
                    buf.append(((MIBRevision)en.nextElement()).toSMI(mode, cs, lineSeparator));
                }
            }
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    protected String toPIB(int mode, int smiversion) {
        return "";
    }

    public Pair toSMI(int mode, MIBRepository rep, int maxBytes, String lineSeparator) {
        MIBObject obj;
        Enumeration en;
        int lastOK = 0;
        StringBuffer buf = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(mode, buf, this.copyrightComment, lineSeparator);
            buf.append(lineSeparator);
        }
        buf.append(this.getModuleName());
        if (buf.length() >= maxBytes) {
            return new Pair(this, new Integer(0));
        }
        this.toSMIDefinitionsBegin(mode, buf);
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        if (buf.length() >= maxBytes) {
            return new Pair(this, new Integer(0));
        }
        if (this.hasImports()) {
            MIBModule.addKeyWord(mode, buf, "IMPORTS");
            en = this.imports.elements();
            while (en.hasMoreElements()) {
                buf.append(lineSeparator);
                MIBImport mi = (MIBImport)en.nextElement();
                buf.append(mi.toSMI(rep, mode, lineSeparator));
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                buf.append(lineSeparator);
            }
            buf.append(";");
            buf.append(lineSeparator);
            buf.append(lineSeparator);
        }
        lastOK = buf.length();
        buf.append(this.toSMI(mode, this.smiVersion, rep, lineSeparator));
        if (buf.length() >= maxBytes) {
            return new Pair(this, new Integer(lastOK));
        }
        en = this.objects();
        while (en.hasMoreElements()) {
            obj = (MIBObject)en.nextElement();
            if (!(obj instanceof MIBTextualConvention)) continue;
            buf.append(lineSeparator);
            lastOK = buf.length();
            buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
            if (buf.length() < maxBytes) continue;
            return new Pair(obj, new Integer(lastOK));
        }
        en = this.objectsByOid().elements();
        while (en.hasMoreElements()) {
            obj = (MIBObject)en.nextElement();
            if (!(obj instanceof MIBModule) && !(obj instanceof MIBTextualConvention)) {
                buf.append(lineSeparator);
                lastOK = buf.length();
                buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
                if (buf.length() < maxBytes) continue;
                return new Pair(obj, new Integer(lastOK));
            }
            if (!(obj instanceof MIBModule) || this.smiVersion != 1 || !obj.getOid().isValid()) continue;
            buf.append(lineSeparator);
            lastOK = buf.length();
            buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
            if (buf.length() < maxBytes) continue;
            return new Pair(this, new Integer(lastOK));
        }
        buf.append(lineSeparator);
        MIBModule.addKeyWord(mode, buf, "END");
        buf.append(lineSeparator);
        return null;
    }

    protected void toSMIDefinitionsBegin(int mode, StringBuffer buf) {
        MIBModule.addKeyWord(mode, buf, " DEFINITIONS ::= BEGIN");
    }

    public Collection objectsOrderedByOccurance() {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(128));
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        return orderedObjects.values();
    }

    private void objectsToSMI(int mode, StringBuffer buf, MIBRepository rep, String lineSeparator) {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(mode));
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o : orderedObjects.values()) {
            if (!(o instanceof MIBModule)) {
                buf.append(lineSeparator);
                buf.append(o.toSMI(mode, this.smiVersion, rep, lineSeparator));
                if (o instanceof MIBTextualConvention || o == null) continue;
                MIBObject[] others = rep.getObjectsByOid(o.getOid());
                for (int i = 0; i < others.length; ++i) {
                    if (o == others[i] || !o.getModuleID().equals(others[i].getModuleID())) continue;
                    buf.append(lineSeparator);
                    buf.append(others[i].toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
                continue;
            }
            if (!(o instanceof MIBModule) || this.smiVersion != 1 || !o.getOid().isValid()) continue;
            buf.append(lineSeparator);
            buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
        }
    }

    public String toSMI(int mode, MIBRepository rep, String lineSeparator) {
        return this.toSMI(mode, rep, lineSeparator, "Object Definitions");
    }

    public String toSMI(int mode, MIBRepository rep, String lineSeparator, String objectsComment) {
        Enumeration en;
        StringBuffer buf = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(mode, buf, this.copyrightComment, lineSeparator);
            buf.append(lineSeparator);
        }
        buf.append(this.getModuleName());
        this.toSMIDefinitionsBegin(mode, buf);
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        if (this.hasImports()) {
            MIBModule.addKeyWord(mode, buf, "IMPORTS");
            en = this.imports.elements();
            while (en.hasMoreElements()) {
                buf.append(lineSeparator);
                MIBImport mi = (MIBImport)en.nextElement();
                buf.append(mi.toSMI(rep, mode, lineSeparator));
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                buf.append(lineSeparator);
            }
            buf.append(";");
            buf.append(lineSeparator);
            buf.append(lineSeparator);
        }
        buf.append(this.toSMI(mode, this.smiVersion, rep, lineSeparator));
        if ((mode & 0x40) == 0) {
            if ((mode & 0x180) > 0) {
                this.objectsToSMI(mode, buf, rep, lineSeparator);
            } else {
                MIBObject obj;
                en = this.objects();
                while (en.hasMoreElements()) {
                    obj = (MIBObject)en.nextElement();
                    if (!(obj instanceof MIBTextualConvention)) continue;
                    buf.append(lineSeparator);
                    buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
                en = this.objectsByOid().elements();
                while (en.hasMoreElements()) {
                    obj = (MIBObject)en.nextElement();
                    if (!(obj instanceof MIBModule) && !(obj instanceof MIBTextualConvention)) {
                        buf.append(lineSeparator);
                        buf.append(obj.toSMI(mode, this.smiVersion, rep, lineSeparator));
                        MIBObject[] o = rep.getObjectsByOid(obj.getOid());
                        for (int i = 0; i < o.length; ++i) {
                            if (obj == o[i] || !obj.getModuleID().equals(o[i].getModuleID())) continue;
                            buf.append(lineSeparator);
                            buf.append(o[i].toSMI(mode, this.smiVersion, rep, lineSeparator));
                        }
                        continue;
                    }
                    if (!(obj instanceof MIBModule) || this.smiVersion != 1 || !obj.getOid().isValid()) continue;
                    buf.append(lineSeparator);
                    buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
            }
        } else {
            MIBModule.addComment(mode, buf, "-- " + lineSeparator + "-- " + objectsComment + lineSeparator + "-- " + lineSeparator, lineSeparator);
        }
        buf.append(lineSeparator);
        MIBModule.addKeyWord(mode, buf, "END");
        buf.append(lineSeparator);
        if (this.hasCopyrightCommentEnd()) {
            MIBModule.addComment(mode, buf, this.copyrightCommentEnd, lineSeparator);
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public void setOrganization(String newOrganization) {
        this.organization = newOrganization;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setLastUpdated(String newLastUpdated) {
        this.lastUpdated = newLastUpdated;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public void setContactInfo(String newContactInfo) {
        this.contactInfo = newContactInfo;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setSMIVersion(int newSmiVersion) {
        this.smiVersion = newSmiVersion;
    }

    public int getSMIVersion() {
        return this.smiVersion;
    }

    public void addRevision(MIBRevision revision) {
        if (this.revisions == null) {
            this.revisions = new Vector(2);
        }
        this.revisions.addElement(revision);
    }

    public void setRevisions(MIBRevision[] refs) {
        this.revisions = MIBRepository.buildVector(refs);
    }

    public boolean hasCopyrightComment() {
        return this.copyrightComment != null && this.copyrightComment.length() > 0;
    }

    public void setCopyrightComment(String copyrightComment) {
        this.copyrightComment = copyrightComment;
    }

    public String getCopyrightCommentEnd() {
        return this.copyrightCommentEnd;
    }

    public boolean hasCopyrightCommentEnd() {
        return this.copyrightCommentEnd != null && this.copyrightCommentEnd.length() > 0;
    }

    public void setCopyrightCommentEnd(String copyrightCommentEnd) {
        this.copyrightCommentEnd = copyrightCommentEnd;
    }

    public String getCopyrightComment() {
        return this.copyrightComment;
    }

    public IRevision[] getRevisions() {
        if (this.revisions == null) {
            return null;
        }
        Object[] r = new MIBRevision[this.revisions.size()];
        this.revisions.copyInto(r);
        return r;
    }

    public void setRevisionsVector(Vector v) {
        this.revisions = v;
    }

    public Vector getRevisionsVector() {
        return this.revisions;
    }

    public boolean hasRevisions() {
        return this.revisions != null && this.revisions.size() > 0;
    }

    public Date getLastChange() {
        return this.lastChange;
    }

    public int getParseMode() {
        return this.parseMode;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setLastChange(Date d) {
        this.lastChange = d;
    }

    public void setParseMode(int parseMode) {
        this.parseMode = parseMode;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public boolean isInitialized() {
        return this.objects != null;
    }

    public Vector getTextualConventions() {
        Vector<MIBObject> v = new Vector<MIBObject>(this.objects.size() / 50, 10);
        for (MIBObject o : this.objects.values()) {
            if (!(o instanceof MIBTextualConvention)) continue;
            v.add(o);
        }
        return v;
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.smiVersion == 1;
        if (valid) {
            return true;
        }
        if (this.getOid() == null || this.getOid().size() == 0) {
            return false;
        }
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (!(o instanceof MIBModule) || !o.equals(this)) continue;
            valid = true;
        }
        return valid;
    }

    public String getImportSource(String objectName) {
        if (!this.hasImports()) {
            return null;
        }
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i = (MIBImport)en.nextElement();
            if (!i.imports(objectName)) continue;
            return i.getSource();
        }
        return null;
    }

    public Vector getImportSources(String objectName) {
        if (!this.hasImports()) {
            return new Vector(1);
        }
        Vector<String> v = new Vector<String>(2);
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i = (MIBImport)en.nextElement();
            if (!i.imports(objectName)) continue;
            v.add(i.getSource());
        }
        return v;
    }

    public MIBImport getImports(String source) {
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            MIBImport i = (MIBImport)en.nextElement();
            if (!i.getSource().equals(source)) continue;
            return i;
        }
        return null;
    }

    public void releaseChangedObjects(int releaseNumber) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (o.isReleased()) continue;
            o.setReleased(releaseNumber);
        }
    }

    public void unreleaseObjects(int releasedNumber) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (o.getReleased() < releasedNumber) continue;
            o.setReleased(0);
        }
    }

    public static Date getDateFromUTC(String utc) {
        int year = 0;
        if (utc.length() == 11 || utc.length() == 13) {
            int offset = 2;
            if (utc.length() == 13) {
                offset = 4;
            } else {
                year = 1900;
            }
            int month = Integer.parseInt(utc.substring(offset, offset + 2)) - 1;
            int day = Integer.parseInt(utc.substring(offset + 2, offset + 4));
            int h = Integer.parseInt(utc.substring(offset + 4, offset + 6));
            int m = Integer.parseInt(utc.substring(offset + 6, offset + 8));
            GregorianCalendar gc = new GregorianCalendar(year += Integer.parseInt(utc.substring(0, offset)), month, day, h, m);
            return gc.getTime();
        }
        return null;
    }

    public static String getTimeFromUTC(String utc) {
        Date d = MIBModule.getDateFromUTC(utc);
        if (d != null) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.US);
            return df.format(d);
        }
        return null;
    }

    public void changeObjectReferences(String oldObjectName, String newObjectName) {
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBVariation v;
            String s;
            int i;
            Serializable m;
            String s2;
            MIBObject o = (MIBObject)en.nextElement();
            if (o instanceof MIBGroup) {
                MIBGroup g = (MIBGroup)o;
                for (int i2 = 0; i2 < g.getObjectsVector().size(); ++i2) {
                    s2 = (String)g.getObjectsVector().elementAt(i2);
                    if (!s2.equals(oldObjectName)) continue;
                    g.getObjectsVector().setElementAt(newObjectName, i2);
                }
                continue;
            }
            if (o instanceof MIBNotifyType) {
                MIBNotifyType n = (MIBNotifyType)o;
                if (!n.hasVariables()) continue;
                for (int i3 = 0; i3 < n.getVariablesVector().size(); ++i3) {
                    s2 = (String)n.getVariablesVector().get(i3);
                    if (!s2.equals(oldObjectName)) continue;
                    n.getVariablesVector().setElementAt(newObjectName, i3);
                }
                continue;
            }
            if (o instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)o;
                if (ot.isTable()) {
                    for (int i4 = 0; i4 < ot.getTableEntriesVector().size(); ++i4) {
                        s2 = (String)ot.getTableEntriesVector().get(i4);
                        if (!s2.equals(oldObjectName)) continue;
                        ot.getTableEntriesVector().setElementAt(newObjectName, i4);
                    }
                }
                if (!ot.hasIndexPart()) continue;
                for (int i5 = 0; i5 < ot.getIndexPart().getIndexPartVector().size(); ++i5) {
                    s2 = (String)ot.getIndexPart().getIndexPartVector().get(i5);
                    if (!s2.equals(oldObjectName)) continue;
                    ot.getIndexPart().getIndexPartVector().setElementAt(newObjectName, i5);
                }
                continue;
            }
            if (o instanceof MIBAgentCaps) {
                MIBAgentCaps ac = (MIBAgentCaps)o;
                Enumeration men = ac.getModules().elements();
                while (men.hasMoreElements()) {
                    m = (MIBSupportedModule)men.nextElement();
                    for (i = 0; i < ((MIBSupportedModule)m).includes.size(); ++i) {
                        s = (String)((MIBSupportedModule)m).includes.elementAt(i);
                        if (!s.equals(oldObjectName)) continue;
                        ((MIBSupportedModule)m).includes.setElementAt(newObjectName, i);
                    }
                    if (!((MIBSupportedModule)m).hasVariations()) continue;
                    for (i = 0; i < ((MIBSupportedModule)m).getVariationsVector().size(); ++i) {
                        v = (MIBVariation)((MIBSupportedModule)m).getVariationsVector().elementAt(i);
                        if (!v.getVariation().equals(oldObjectName)) continue;
                        v.setVariation(newObjectName);
                    }
                }
                continue;
            }
            if (!(o instanceof MIBCompliance)) continue;
            MIBCompliance c = (MIBCompliance)o;
            Enumeration men = c.getModules().elements();
            while (men.hasMoreElements()) {
                m = (MIBComplianceModule)men.nextElement();
                if (((MIBComplianceModule)m).hasMandatory()) {
                    for (i = 0; i < ((MIBComplianceModule)m).getMandatoryVector().size(); ++i) {
                        s = (String)((MIBComplianceModule)m).getMandatoryVector().elementAt(i);
                        if (!s.equals(oldObjectName)) continue;
                        ((MIBComplianceModule)m).getMandatoryVector().setElementAt(newObjectName, i);
                    }
                }
                if (!((MIBComplianceModule)m).hasVariations()) continue;
                for (i = 0; i < ((MIBComplianceModule)m).getVariationsVector().size(); ++i) {
                    v = (MIBVariation)((MIBComplianceModule)m).getVariationsVector().elementAt(i);
                    if (v.getVariation() == null || !v.getVariation().equals(oldObjectName)) continue;
                    v.setVariation(newObjectName);
                }
            }
        }
    }

    public void convertToSMIv1(MIBRepository rep) {
        MIBObject o;
        if (this.getSMIVersion() == 1) {
            return;
        }
        this.setSMIVersion(1);
        MIBObject mo = new MIBObject(this.getOid(), this.getName(), this.getModuleID());
        this.add(mo);
        rep.removeObject(this);
        this.oid = new ObjectID();
        rep.addObject(this);
        rep.addObject(mo);
        rep.structureChanged();
        Vector<MIBObject> victims = new Vector<MIBObject>();
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            o = (MIBObject)en.nextElement();
            if (o.getStatus() != null && o.getStatus().equals(SMI.STATUS[5])) {
                o.setStatus(SMI.STATUS[1]);
            }
            MIBSyntax syn = null;
            if (o instanceof MIBObjectType) {
                MIBObject entry;
                MIBObjectType ot = (MIBObjectType)o;
                if (ot.hasIndexPart() && ot.getIndexPart().isAugment() && (entry = rep.getObject(ot.getIndexPart().getIndexPart()[0])) != null && entry instanceof MIBObjectType) {
                    ot.setIndexPart(new MIBIndexPart(((MIBObjectType)entry).getIndexPart()));
                }
                ot.setUnits(null);
                if (ot.getAccess().equals(SMI.ACCESS[3])) {
                    ot.setAccess(SMI.ACCESS[2]);
                }
                syn = ot.getSyntax();
            }
            if (o instanceof MIBTextualConvention) {
                syn = ((MIBTextualConvention)o).getSyntax();
                ((MIBTextualConvention)o).setStatus(null);
            }
            if (syn != null) {
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[5]) || syn.getSyntax().equals(SMI.SMI_SYNTAX[6])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[3]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[7])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[13])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[8])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[0]);
                }
                if (syn.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    syn.setSyntax(SMI.SMI_SYNTAX[1]);
                    if (syn.hasEnums()) {
                        MIBObjectType ot;
                        StringBuffer buf = new StringBuffer();
                        Enumeration enumeration = syn.getEnumsVector().elements();
                        while (enumeration.hasMoreElements()) {
                            buf.append("-- " + enumeration.nextElement().toString() + "\n");
                        }
                        String oldComment = "";
                        if (o.hasComment()) {
                            oldComment = o.getComment();
                        }
                        o.setComment(oldComment + "\n" + "-- BITS: " + "\n" + buf.toString());
                        if (o instanceof MIBObjectType && (ot = (MIBObjectType)o).hasDefaultValue()) {
                            byte[] defVal = syn.getBitsEnum(ot.getDefaultValue());
                            StringBuffer b = new StringBuffer("'");
                            if (defVal != null) {
                                for (int i = 0; i < defVal.length; ++i) {
                                    b.append(Integer.toHexString(defVal[i]));
                                }
                            }
                            b.append("'h");
                            ot.setDefaultValue(b.toString());
                        }
                        syn.setEnumsVector(null);
                    }
                }
            }
            if (o instanceof MIBNotifyType) {
                ((MIBNotifyType)o).setTrapType(2);
                try {
                    MIBObject obj = rep.getObject(o.getOid().getPrefix(o.getOid().size() - 2));
                    if (obj != null) {
                        ((MIBNotifyType)o).setEnterprise(obj.getName());
                    } else {
                        ((MIBNotifyType)o).setEnterprise(o.getOid().getPrefix(o.getOid().size() - 2).toString());
                    }
                }
                catch (ObjectIDFormatException ex) {
                    // empty catch block
                }
            }
            if (!(o instanceof MIBGroup) && !(o instanceof MIBCompliance) && !(o instanceof MIBAgentCaps)) continue;
            victims.addElement(o);
        }
        en = victims.elements();
        while (en.hasMoreElements()) {
            o = (MIBObject)en.nextElement();
            rep.removeObject(o);
            this.remove(o);
        }
        this.autoImportSMIMacros();
    }

    private void autoImportSMIMacros() {
        int i;
        for (int i2 = 0; i2 < STANDARD_MIBS.length; ++i2) {
            if (!this.getModuleName().equals(STANDARD_MIBS[i2])) continue;
            return;
        }
        int v = this.getSMIVersion();
        Enumeration en = this.getImportsVector().elements();
        while (en.hasMoreElements()) {
            MIBImport imp = (MIBImport)en.nextElement();
            for (i = 0; i < imp.getImportsVector().size(); ++i) {
                String s = (String)imp.getImportsVector().get(i);
                if (SMI.getKeyWordType(1, s) >= 0) {
                    imp.getImportsVector().remove(i);
                    --i;
                } else if (SMI.getKeyWordType(2, s) >= 0) {
                    imp.getImportsVector().remove(i);
                    --i;
                }
                if (v >= 0 || SMI.getKeyWordType(v, s) < 0) continue;
                imp.getImportsVector().remove(i);
                --i;
            }
        }
        String[][] constructs = v > 0 ? SMI.smiConstructs[v - 1] : SMI.pibConstructs[Math.abs(v) - 1];
        String[] mibs = v > 0 ? SMI.smiMIBs[v - 1] : SMI.pibMIBs[Math.abs(v) - 1];
        for (i = 0; i < constructs.length; ++i) {
            block4: for (int j = 0; j < constructs[i].length; ++j) {
                Enumeration en2 = this.objects();
                while (en2.hasMoreElements()) {
                    MIBObject o = (MIBObject)en2.nextElement();
                    if (!o.getTypeString().equals(constructs[i][j]) && (!(o instanceof MIBObjectType) || !((MIBObjectType)o).getSyntax().getSyntax().equals(constructs[i][j])) && (!(o instanceof MIBTextualConvention) || !((MIBTextualConvention)o).getSyntax().getSyntax().equals(constructs[i][j]))) continue;
                    MIBImport imp = this.getImports(mibs[i]);
                    if (imp == null) {
                        imp = new MIBImport(mibs[i]);
                        this.getImportsVector().add(imp);
                    }
                    imp.addImport(constructs[i][j]);
                    continue block4;
                }
            }
        }
        for (i = 0; i < this.getImportsVector().size(); ++i) {
            MIBImport imp = (MIBImport)this.getImportsVector().get(i);
            if (imp.getImportsVector().size() != 0) continue;
            this.getImportsVector().remove(i);
            --i;
        }
    }

    public Collection getLowerCaseNames() {
        HashSet<String> l = new HashSet<String>();
        if (this.imports != null) {
            for (int i = 0; i < this.imports.size(); ++i) {
                MIBImport imp = (MIBImport)this.imports.get(i);
                String[] imps = imp.getImports();
                for (int j = 0; j < imps.length; ++j) {
                    if (imps[j].length() <= 0 || !Character.isLowerCase(imps[j].charAt(0))) continue;
                    l.add(imps[j]);
                }
            }
        }
        Iterator it = this.objectsIterator();
        while (it.hasNext()) {
            MIBObject o = (MIBObject)it.next();
            if (o.getName().length() <= 0 || !Character.isLowerCase(o.getName().charAt(0))) continue;
            l.add(o.getName());
        }
        return l;
    }

    public Collection getUpperCaseNames() {
        HashSet<String> l = new HashSet<String>();
        if (this.imports != null) {
            for (int i = 0; i < this.imports.size(); ++i) {
                MIBImport imp = (MIBImport)this.imports.get(i);
                String[] imps = imp.getImports();
                for (int j = 0; j < imps.length; ++j) {
                    if (imps[j].length() <= 0 || !Character.isUpperCase(imps[j].charAt(0))) continue;
                    l.add(imps[j]);
                }
            }
        }
        Iterator it = this.objectsIterator();
        while (it.hasNext()) {
            MIBObject o = (MIBObject)it.next();
            if (o.getName().length() <= 0 || !Character.isUpperCase(o.getName().charAt(0))) continue;
            l.add(o.getName());
        }
        return l;
    }

    private static int getTimezoneOffsetGMT() {
        GregorianCalendar calendar = new GregorianCalendar();
        int off = TimeZone.getDefault().getOffset(1, calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        return off;
    }

    public static String getUTCTime(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        String utc = formatter.format(new Date(time - (long)MIBModule.getTimezoneOffsetGMT()));
        utc = utc + "Z";
        return utc;
    }
}

