/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smi.ext.SMIIndexPart;
import java.io.Serializable;
import java.util.Vector;

public class MIBIndexPart
implements Serializable,
SMIIndexPart {
    public static final long serialVersionUID = 1000L;
    protected Vector indecies = new Vector(1);
    protected int type = 1;
    protected boolean implied = false;
    public static final int INDEX = 1;
    public static final int AUGMENT = 2;

    public MIBIndexPart() {
        this.setType(1);
    }

    public MIBIndexPart(int type) {
        this.setType(type);
    }

    public MIBIndexPart(int type, Vector indexes) {
        this.setType(type);
        this.indecies = indexes;
    }

    public MIBIndexPart(MIBIndexPart other) {
        this.setIndexPart(other.getIndexPart());
        this.implied = other.implied;
        this.type = other.type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAugment() {
        return this.type == 2;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addIndexPart(String index) {
        if (this.indecies == null) {
            this.indecies = new Vector(3);
        }
        this.indecies.addElement(index);
    }

    public void setIndexPart(String[] indexes) {
        this.indecies = MIBRepository.buildVector(indexes);
    }

    public String[] getIndexObjects() {
        return this.getIndexPart();
    }

    public String[] getIndexPart() {
        if (this.indecies == null) {
            return null;
        }
        Object[] s = new String[this.indecies.size()];
        this.indecies.copyInto(s);
        return s;
    }

    public Vector getIndexPartVector() {
        return this.indecies;
    }

    public void setIndexPartVector(Vector v) {
        this.indecies = v;
    }

    public boolean isImplied() {
        return this.implied;
    }

    public void setImplied(boolean implied) {
        this.implied = implied;
    }

    public boolean getImplied() {
        return this.isImplied();
    }

    public String toSMI(int mode, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        if (this.getType() == 1) {
            MIBObject.addKeyWord(mode, buf, "INDEX ");
        } else {
            MIBObject.addKeyWord(mode, buf, "AUGMENTS ");
        }
        buf.append("{");
        buf.append(lineSeparator);
        String[] ind = this.getIndexPart();
        Vector v = (Vector)this.indecies.clone();
        if (this.implied) {
            v.removeElementAt(v.size() - 1);
        }
        buf.append(MIBObject.formatObjectRefs(mode, "\t\t", v.iterator(), lineSeparator));
        if (this.implied) {
            if (v.size() > 0) {
                buf.append(",");
                buf.append(lineSeparator);
            } else {
                buf.append(" ");
            }
            buf.append("\t\t");
            MIBObject.addKeyWord(mode, buf, "IMPLIED ");
            buf.append(this.indecies.elementAt(this.indecies.size() - 1).toString());
        }
        buf.append(" }");
        buf.append(lineSeparator);
        return buf.toString();
    }

    public String toString() {
        return this.toSMI(1, "\n");
    }

    public IndexStruct[] getIndexStruct(MIBRepository repository) {
        boolean isImplied = this.isImplied();
        String[] ind = this.getIndexPart();
        if (this.getType() == 2) {
            MIBObjectType o = (MIBObjectType)repository.getObject(ind[0]);
            ind = o.getIndexPart().getIndexPart();
            isImplied = o.getIndexPart().isImplied();
        }
        IndexStruct[] r = new IndexStruct[ind.length];
        int minlen = 0;
        for (int i = 0; i < ind.length; ++i) {
            MIBObjectType ot = (MIBObjectType)repository.getObject(ind[i]);
            if (ot == null || ot.getSyntax() == null) {
                return null;
            }
            MIBTextualConvention tc = repository.getEffectiveSyntax(ot.getSyntax());
            MIBSyntax s = tc.getSyntax();
            if (s == null) {
                s = ot.getSyntax();
            }
            if (s.getSyntax().equals("INTEGER") || s.getSyntax().equals("TruthValue") || s.getSyntax().equals("Integer32") || s.getSyntax().equals("Counter") || s.getSyntax().equals("Counter32") || s.getSyntax().equals("UInteger32") || s.getSyntax().equals("Unsigned32") || s.getSyntax().equals("Gauge") || s.getSyntax().equals("Gauge32") || s.getSyntax().equals("TimeTicks") || s.getSyntax().equals("TimeStamp")) {
                r[i] = new IndexStruct(ind[i], 0, false, 1, 1);
                ++minlen;
                continue;
            }
            if (s.getSyntax().equals("IpAddress")) {
                r[i] = new IndexStruct(ind[i], 5, false, 4, 4);
                minlen += 4;
                continue;
            }
            if (s.getSyntax().equals("NetworkAddress")) {
                r[i] = new IndexStruct(ind[i], 12, false, 5, 5);
                minlen += 5;
                continue;
            }
            if (s.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                r[i] = new IndexStruct(ind[i], 3, isImplied && i + 1 == ind.length, 2, 128 - minlen);
                continue;
            }
            if (s.getSyntax().startsWith("OCTET") || s.getSyntax().startsWith("BITS") || s.getSyntax().startsWith("Opaque")) {
                if (s.hasRanges() && s.getRanges().length == 1) {
                    try {
                        int lower = s.getRanges()[0].getLower().intValue();
                        int upper = s.getRanges()[0].getUpper().intValue();
                        minlen += lower;
                        if (isImplied && i + 1 == ind.length) {
                            r[i] = new IndexStruct(ind[i], 1, true, lower, Math.min(upper, 128 - minlen));
                            continue;
                        }
                        r[i] = new IndexStruct(ind[i], 1, false, lower, Math.min(upper, 128 - minlen));
                    }
                    catch (NumberFormatException nfe) {
                        r[i] = null;
                    }
                    continue;
                }
                r[i] = new IndexStruct(ind[i], 1, isImplied && i + 1 == ind.length, 0, 128 - minlen);
                continue;
            }
            if (!s.getSyntax().equals("Counter64")) continue;
        }
        return r;
    }
}

