/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smi.ext.SMIException;
import java.io.Serializable;

public class MIBException
extends MIBVariation
implements SMIException,
Serializable {
    public static final long serialVersionUID = 1000L;

    public MIBException() {
    }

    public MIBException(String name, String descr) {
        this.setVariation(name);
        this.setDescription(descr);
    }

    public MIBException(MIBException other) {
        super(other);
    }

    public String toSMI(int mode, MIBRepository rep, MIBVariation c, String lineSeparator) {
        Object cs;
        StringBuffer buf = new StringBuffer();
        buf.append(lineSeparator);
        buf.append("\t");
        MIBObject.addKeyWord(mode, buf, "OBJECT ");
        MIBObject.addString(mode, buf, this.getVariation(), c == null ? null : c.getVariation());
        buf.append(lineSeparator);
        if (this.getSyntax() != null) {
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "SYNTAX ");
            cs = null;
            if (c != null) {
                cs = c.getSyntax() != null ? c.getSyntax() : new MIBSyntax();
            }
            buf.append(this.getSyntax().toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.getWriteSyntax() != null) {
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "WRITE-SYNTAX ");
            cs = null;
            if (c != null) {
                cs = c.getWriteSyntax() != null ? c.getWriteSyntax() : new MIBSyntax();
            }
            buf.append(this.getWriteSyntax().toSMI(mode, rep, (MIBSyntax)cs, lineSeparator));
        }
        if (this.getAccess() != null) {
            buf.append("\t  ");
            MIBObject.addKeyWord(mode, buf, "MIN-ACCESS ");
            cs = null;
            if (c != null) {
                cs = c.getAccess() != null ? c.getAccess() : "";
            }
            MIBObject.addString(mode, buf, this.getAccess(), (String)cs);
            buf.append(lineSeparator);
        }
        buf.append("\t  ");
        MIBObject.addKeyWord(mode, buf, "DESCRIPTION ");
        buf.append(lineSeparator);
        MIBObject.addText(lineSeparator, mode, buf, MIBObject.formatLines("\t\t", this.getDescription()), c == null ? null : MIBObject.formatLines("\t\t", c.getDescription()));
        return buf.toString();
    }
}

