/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.tree;

import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DumpMIBTree {
    protected OutputStream os;

    public DumpMIBTree(OutputStream os) {
        this.os = os;
    }

    public static String getAccessFlags(MIBObjectType ot) {
        int access = SMI.accessType(ot.getAccess());
        switch (access) {
            case 5: {
                return "--n";
            }
            case 1: {
                return "r-n";
            }
            case 2: {
                return "rwn";
            }
            case 3: {
                return "rcn";
            }
        }
        return "---";
    }

    public static char getStatusChar(MIBObject o) {
        int status = SMI.statusType(o.getStatus());
        switch (status) {
            case 5: {
                return '+';
            }
            case 4: {
                return 'x';
            }
            case 1: {
                return '+';
            }
            case 2: {
                return '*';
            }
            case 3: {
                return 'o';
            }
        }
        return '+';
    }

    protected void printSubtree(DefaultMutableTreeNode node, String prefix, char subtreePrefix, int maxTypeLength) throws IOException {
        Object child;
        Object o = node.getUserObject();
        StringBuffer buf = new StringBuffer();
        if (o instanceof MIBObjectType) {
            MIBObjectType ot = (MIBObjectType)o;
            if (ot.isTable()) {
                buf.append(prefix);
                buf.append(DumpMIBTree.getStatusChar(ot));
                buf.append("-- ");
                buf.append(ot.getName());
                buf.append('(');
                try {
                    buf.append(ot.getOid().getLastSubID());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                buf.append(") [");
                buf.append(MIBRepository.buildStringEnumeration(ot.getIndexPart().getIndexPartVector().elements()));
                if (ot.getIndexPart().isImplied()) {
                    buf.append("*");
                }
                if (ot.getIndexPart().isAugment()) {
                    buf.append("+");
                }
                buf.append("]\n");
            } else {
                buf.append(prefix);
                buf.append(DumpMIBTree.getStatusChar(ot));
                buf.append("-- ");
                if (node.isLeaf() || !(((DefaultMutableTreeNode)node.getFirstChild()).getUserObject() instanceof MIBObject)) {
                    buf.append(DumpMIBTree.getAccessFlags(ot) + " ");
                }
                String s = ot.getSyntax().getSyntax();
                buf.append(s);
                buf.append(MIBObject.space(maxTypeLength - s.length() + 1));
                buf.append(ot.getName());
                buf.append('(');
                try {
                    buf.append(ot.getOid().getLastSubID());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                buf.append(")\n");
            }
        } else if (o instanceof MIBNotifyType) {
            MIBNotifyType nt = (MIBNotifyType)o;
            buf.append(prefix);
            buf.append(DumpMIBTree.getStatusChar(nt));
            buf.append("-- ");
            buf.append(nt.getName());
            buf.append('(');
            try {
                buf.append(nt.getOid().getLastSubID());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (nt.hasVariables() && nt.getVariablesVector().size() < 4) {
                buf.append(") [");
                buf.append(MIBRepository.buildStringEnumeration(nt.getVariablesVector().elements()));
                buf.append("]\n");
            } else {
                buf.append(") [");
                if (nt.hasVariables()) {
                    buf.append("\n");
                    buf.append(MIBRepository.buildStringEnumeration(nt.getVariablesVector().elements(), prefix + "        "));
                }
                buf.append(" ]\n");
            }
        } else if (o instanceof MIBGroup) {
            MIBGroup g = (MIBGroup)o;
            buf.append(prefix);
            buf.append(DumpMIBTree.getStatusChar(g));
            buf.append("-- ");
            buf.append(g.getName());
            buf.append('(');
            try {
                buf.append(g.getOid().getLastSubID());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (g.getObjectsVector().size() < 4) {
                buf.append(") [");
                buf.append(MIBRepository.buildStringEnumeration(g.getObjectsVector().elements()));
                buf.append("]\n");
            } else {
                buf.append(") [\n");
                buf.append(MIBRepository.buildStringEnumeration(g.getObjectsVector().elements(), prefix + "        "));
                buf.append(" ]\n");
            }
        } else if (o instanceof MIBObject) {
            if (!(o instanceof MIBTextualConvention)) {
                MIBObject obj = (MIBObject)o;
                buf.append(prefix);
                buf.append(DumpMIBTree.getStatusChar(obj));
                buf.append("-- ");
                buf.append(obj.getName());
                buf.append('(');
                try {
                    buf.append(obj.getOid().getLastSubID());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                buf.append(")\n");
            }
        } else {
            String s = this.printOtherObject(o);
            if (s != null) {
                buf.append(prefix);
                buf.append('+');
                buf.append(s);
                buf.append('\n');
            }
        }
        int newMaxTypeLength = 9;
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            int l;
            child = ((DefaultMutableTreeNode)en.nextElement()).getUserObject();
            if (!(child instanceof MIBObjectType) || (l = ((MIBObjectType)child).getSyntax().getSyntax().length()) <= newMaxTypeLength) continue;
            newMaxTypeLength = l;
        }
        this.os.write(buf.toString().getBytes());
        buf = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            child = (DefaultMutableTreeNode)node.getChildAt(i);
            String s = new String(prefix + subtreePrefix);
            this.os.write(s.getBytes());
            this.os.write("  |\n".getBytes());
            char newSubtreePrefix = ' ';
            if (node.getChildCount() != 1 && i != node.getChildCount() - 1) {
                newSubtreePrefix = '|';
            }
            this.printSubtree((DefaultMutableTreeNode)child, prefix + subtreePrefix + "  ", newSubtreePrefix, newMaxTypeLength);
        }
    }

    protected String printOtherObject(Object o) {
        return null;
    }

    public void printSubtree(DefaultMutableTreeNode node) throws IOException {
        this.printSubtree(node, "", ' ', 0);
    }
}

