/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.editor.Token;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class SmiKitTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("need filename argument");
            System.exit(1);
        }
        try {
            JEditorPane editor = new JEditorPane();
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKitForContentType("text/smi", kit);
            editor.setContentType("text/smi");
            editor.setBackground(Color.white);
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            SmiContext styles = kit.getStylePreferences();
            Color keyword = Color.orange;
            for (int code = 0; code < Token.all.length; ++code) {
                Token t = Token.all[code];
                Style s = styles.getStyleForScanValue(t.getScanValue());
                if (s == null) continue;
                if (t instanceof Token.Statement) {
                    StyleConstants.setBold(s, true);
                    StyleConstants.setForeground(s, Color.black);
                    continue;
                }
                if (t instanceof Token.Clause) {
                    StyleConstants.setBold(s, true);
                    StyleConstants.setForeground(s, Color.gray);
                    continue;
                }
                if (t instanceof Token.Text) {
                    StyleConstants.setBold(s, false);
                    StyleConstants.setForeground(s, new Color(70, 70, 180));
                    continue;
                }
                if (t instanceof Token.Identifier) {
                    StyleConstants.setBold(s, false);
                    StyleConstants.setForeground(s, Color.darkGray);
                    continue;
                }
                if (t instanceof Token.Special) {
                    StyleConstants.setItalic(s, true);
                    StyleConstants.setForeground(s, Color.red);
                    continue;
                }
                if (!(t instanceof Token.Value)) continue;
                StyleConstants.setForeground(s, new Color(150, 150, 155));
            }
            File file = new File(args[0]);
            editor.read(new FileReader(file), (Object)file);
            JScrollPane scroller = new JScrollPane();
            JViewport vp = scroller.getViewport();
            vp.add(editor);
            JFrame f = new JFrame("JavaEditorKit: " + args[0]);
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add("Center", scroller);
            f.pack();
            f.setSize(600, 600);
            f.setVisible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

