/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.Token;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.smiparser.SMIParserTokenManager;
import com.agentpp.smiparser.SimpleCharStream;
import com.agentpp.smiparser.TokenMgrError;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class SmiDocument
extends PlainDocument {
    private boolean _$2858;

    public SmiDocument() {
        super(new GapContent(1024));
    }

    public Scanner createScanner() {
        Scanner s;
        try {
            s = new Scanner();
        }
        catch (IOException e) {
            s = null;
        }
        return s;
    }

    public int getLineOfOffset(int offset) {
        return super.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineLength(int line) {
        Element l = super.getDefaultRootElement().getElement(line);
        return l.getEndOffset() - l.getStartOffset();
    }

    public int getLineCount() {
        return super.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getStartOffset();
    }

    public int getLineEndOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getEndOffset();
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (chng.getOffset() + chng.getLength() + 1 < chng.getDocument().getEndPosition().getOffset()) {
            this._$2858 = true;
        }
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        this._$2858 = true;
    }

    public void setUpdated(boolean updated) {
        this._$2858 = updated;
    }

    public boolean isUpdated() {
        return this._$2858;
    }

    class DocumentInputStream
    extends InputStream {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentInputStream(int p0, int p1) {
            this.p0 = p0;
            this.p1 = Math.min(SmiDocument.this.getLength(), p1);
            this.pos = p0;
            try {
                this.loadSegment();
            }
            catch (IOException ioe) {
                throw new Error("unexpected: " + ioe);
            }
        }

        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        void loadSegment() throws IOException {
            try {
                int n = Math.min(1024, this.p1 - this.pos);
                SmiDocument.this.getText(this.pos, n, this.segment);
                this.pos += n;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e) {
                throw new IOException("Bad location");
            }
        }
    }

    public class Scanner {
        private SMIParserTokenManager _$2888;
        private SimpleCharStream _$2889;
        private Token[] _$2890;
        private com.agentpp.smiparser.Token _$2891;
        private com.agentpp.smiparser.Token _$2892;
        private OrderedMap _$2893 = new OrderedMap();
        int p0;

        Scanner() throws IOException {
            this._$2894();
            this._$2889 = new SimpleCharStream(new DocumentInputStream(0, SmiDocument.this.getLength()));
            this._$2888 = new SMIParserTokenManager(this._$2889);
        }

        private void _$2894() {
            this._$2890 = new Token[SMIParserConstants.tokenImage.length];
            block0: for (int i = 0; i < this._$2890.length; ++i) {
                for (int j = 0; j < Token.all.length; ++j) {
                    if (Token.all[j].getScanValue() != i) continue;
                    this._$2890[i] = Token.all[j];
                    continue block0;
                }
            }
        }

        public void setRange(int p0, int p1) throws IOException {
            this._$2889 = new SimpleCharStream(new DocumentInputStream(p0, p1), 0, 0, 4096, p0);
            this._$2888.ReInit(this._$2889);
            this._$2891 = null;
            this._$2892 = null;
            this.p0 = p0;
            Integer i0 = new Integer(p0);
            this._$2893.remove(this._$2893.lowerBound(i0), this._$2893.end());
        }

        public final int getEndOffset() {
            if (this._$2891 == null) {
                this.getNextToken();
                if (this._$2891 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$2892 != null) {
                return this._$2892.endPos;
            }
            return this._$2891.endPos;
        }

        public int getTokenLength() {
            return this.getEndOffset() - this.getBeginOffset();
        }

        public final int getBeginOffset() {
            if (this._$2891 == null) {
                this.getNextToken();
                if (this._$2891 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$2892 != null) {
                return this._$2892.endPos - this._$2892.image.length();
            }
            return this._$2891.endPos - this._$2891.image.length();
        }

        public final Token getToken() {
            if (this._$2891 == null) {
                return this.getNextToken();
            }
            Token t = this._$2892 != null ? this._$2890[this._$2892.kind] : this._$2890[this._$2891.kind];
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }

        private void _$2919(int pos) {
            Integer p = new Integer(pos);
            this._$2893.put(p, p);
        }

        public int getScannerStart(int p) {
            Integer i = new Integer(p);
            OrderedMapIterator it = this._$2893.lowerBound(i);
            if (!it.atBegin()) {
                it.retreat();
            }
            if (it.atBegin() || it.atEnd()) {
                return 0;
            }
            int v = (Integer)((Pair)it.get()).first;
            if (v < 0) {
                v = 0;
            }
            return v;
        }

        public final Token getNextToken() {
            Token t = null;
            if (this._$2892 != null) {
                t = this._$2890[this._$2892.kind];
                this._$2892 = this._$2892.next;
                return t;
            }
            try {
                this._$2891 = this._$2888.getNextToken();
                this._$2892 = this._$2891.specialToken;
                if (this._$2892 != null) {
                    while (this._$2892.specialToken != null) {
                        this._$2892 = this._$2892.specialToken;
                    }
                    t = this._$2890[this._$2892.kind];
                } else {
                    t = this._$2890[this._$2891.kind];
                }
                this._$2919(this._$2891.endPos - this._$2891.image.length());
            }
            catch (TokenMgrError error) {
                this._$2891 = null;
                return Token.ERROR;
            }
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }
    }
}

