/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.log;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.common.log.LogPreferencesPanel;
import com.agentpp.common.log.LoggingListener;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.spi.LoggingEvent;

public class LogPanel
extends JPanel
implements JCCellDisplayListener,
LoggingListener {
    public static final String CFG_EXPORT_PATH = "com.agentpp.log.exportPath";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static SimpleDateFormat _$30932 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String[] _$22066 = new String[]{"Priority", "Category", "Message"};
    public static ImageIcon imageProperties16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Properties16.gif"));
    public static ImageIcon imageSaveAs16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif"));
    public static ImageIcon imageDelete16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Delete16.gif"));
    public static ImageIcon imageRemove16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Remove16.gif"));
    public static ImageIcon imageStop16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Stop16.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton jButtonPreferences = new JButton();
    JButton jButtonClear = new JButton();
    JButton jButtonSaveAs = new JButton();
    JToggleButton jButtonStop = new JToggleButton();
    JPanel jPanelLogging = new JPanel();
    JCListTable table = new FlexListTable();
    JCEditableVectorDataSource model = new JCEditableVectorDataSource();
    BorderLayout borderLayout2 = new BorderLayout();
    private LogPreferencesPanel _$30942;
    private JFrame _$11194;
    JButton jButtonDelete = new JButton();
    private int _$30944 = 100;
    private StatusBar _$14253;
    private Properties _$6388;
    private LinkedList _$30945 = new LinkedList();
    private LinkedList _$30946 = new LinkedList();
    private boolean _$5994;

    public LogPanel(JFrame f, StatusBar statusBar, Properties config) {
        this._$14253 = statusBar;
        this._$6388 = config;
        this._$11194 = f;
        this.model.setColumnLabels(_$22066);
        this.model.setNumRows(0);
        this.model.setNumColumns(_$22066.length);
        this.table.setDataSource(this.model);
        this.table.setColumnLabelDisplay(true);
        this.table.setRowLabelDisplay(true);
        this.table.setVariableEstimateCount(5);
        this.table.setCharWidth(0, 8);
        this.table.setCharWidth(-1, 13);
        this.table.setPixelWidth(1, 33002);
        this.table.setCharWidth(2, 400);
        this.table.addCellDisplayListener(this);
        this.table.setVertSBTrack(1);
        this.table.getSelectionModel().setSelectionPolicy(2);
        this.table.getDefaultCellStyle().setEditable(false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPreferencesPanel(LogPreferencesPanel prefPanel) {
        this._$30942 = prefPanel;
        this._$30944 = prefPanel.getMaxLogRecords();
        prefPanel.reloadConfiguration();
    }

    public void cellDisplay(JCCellDisplayEvent e) {
        if (e.getCellData() != null && e.getCellData() instanceof Date) {
            String display = _$30932.format((Date)e.getCellData());
            e.setDisplayData(display);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LoggingEvent e) {
        if (this._$30944 == 0) {
            return;
        }
        if (this._$5994) {
            this._$30945.addLast(e);
            if (this._$30945.size() > this._$30944) {
                this._$30945.removeFirst();
            }
        } else {
            Vector<Object> row = new Vector<Object>(3);
            row.addElement(e.getLevel());
            row.addElement(e.getLoggerName());
            String renderedMessage = e.getRenderedMessage();
            if (renderedMessage == null) {
                renderedMessage = "Nullpointer Exception";
            }
            String s = renderedMessage.replace('\t', '\n');
            row.addElement(s);
            Date date = new Date(e.timeStamp);
            if (SwingUtilities.isEventDispatchThread() || !this.table.isRepaintEnabled()) {
                this._$4278(row, date);
            } else {
                LinkedList linkedList = this._$30946;
                synchronized (linkedList) {
                    this._$30946.addLast(new Object[]{row, date});
                    if (this._$30946.size() == 1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                LinkedList linkedList = LogPanel.this._$30946;
                                synchronized (linkedList) {
                                    boolean isRepaint = LogPanel.this.table.isRepaintEnabled();
                                    while (LogPanel.this._$30946.size() > 0) {
                                        Object[] r = (Object[])LogPanel.this._$30946.removeFirst();
                                        LogPanel.this._$4278((Vector)r[0], (Date)r[1]);
                                    }
                                    if (isRepaint) {
                                        LogPanel.this.table.traverse(LogPanel.this.model.getNumRows() - 1, 0, false, false);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$4278(Vector row, Date date) {
        LinkedList linkedList = this._$30945;
        synchronized (linkedList) {
            StringTokenizer st;
            int numLines;
            int diff = this.model.getNumRows() - this._$30944;
            if (diff >= 0) {
                this.model.deleteRows(0, diff);
            }
            if (this.model.addRow(Integer.MAX_VALUE, date, row) && (numLines = (st = new StringTokenizer((String)row.get(2), "\n")).countTokens()) > 1) {
                this.table.setCharHeight(this.model.getNumRows() - 1, st.countTokens());
            }
            if (this.table.isRepaintEnabled()) {
                this.table.traverse(this.model.getNumRows() - 1, 0, false, false);
            }
        }
    }

    public JCVectorDataSource getDataSource() {
        return this.model;
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.jButtonPreferences.setIcon(imageProperties16);
        this.jButtonPreferences.setToolTipText("Configure logging priorities and other properties");
        this.jButtonPreferences.setHorizontalAlignment(2);
        this.jButtonPreferences.setText("Properties");
        this.jButtonPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.jButtonPreferences_actionPerformed(e);
            }
        });
        this.jButtonClear.setIcon(imageDelete16);
        this.jButtonClear.setToolTipText("Clear log");
        this.jButtonClear.setHorizontalAlignment(2);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.jButtonClear_actionPerformed(e);
            }
        });
        this.jButtonStop.setIcon(imageStop16);
        this.jButtonStop.setToolTipText("Suspend logging");
        this.jButtonStop.setHorizontalAlignment(2);
        this.jButtonStop.setText("Suspend");
        this.jButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.jButtonStop_actionPerformed(e);
            }
        });
        this.jButtonSaveAs.setIcon(imageSaveAs16);
        this.jButtonSaveAs.setToolTipText("Save logging output as text file");
        this.jButtonSaveAs.setHorizontalAlignment(2);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.jButtonSaveAs_actionPerformed(e);
            }
        });
        this.jPanelLogging.setLayout(this.borderLayout2);
        this.jButtonDelete.setIcon(imageRemove16);
        this.jButtonDelete.setToolTipText("Remove selected entries");
        this.jButtonDelete.setHorizontalAlignment(2);
        this.jButtonDelete.setText("Remove");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.jButtonDelete_actionPerformed(e);
            }
        });
        this.add((Component)this.jPanelButtons, "West");
        this.jPanelButtons.add((Component)this.jButtonPreferences, null);
        this.jPanelButtons.add((Component)this.jButtonClear, null);
        this.jPanelButtons.add((Component)this.jButtonDelete, null);
        this.jPanelButtons.add((Component)this.jButtonSaveAs, null);
        this.jPanelButtons.add(new JSeparator());
        this.jPanelButtons.add((Component)this.jButtonStop, null);
        this.add((Component)this.jPanelLogging, "Center");
        this.jPanelLogging.add((Component)this.table, "Center");
    }

    void jButtonPreferences_actionPerformed(ActionEvent e) {
        StandardDialog sd = new StandardDialog(this._$11194, "Logging Properties", true, true){

            public boolean cancel() {
                LogPanel.this._$30942.cancel();
                return true;
            }

            public boolean ok() {
                LogPanel.this._$30942.save();
                return true;
            }
        };
        sd.setCenterPanel(this._$30942);
        sd.setLocationRelativeTo(this._$11194);
        sd.setVisible(true);
        this._$30944 = this._$30942.getMaxLogRecords();
    }

    void jButtonClear_actionPerformed(ActionEvent e) {
        this.model.setNumRows(0);
    }

    void jButtonStop_actionPerformed(ActionEvent event) {
        boolean old = this._$5994;
        this._$5994 = this.jButtonStop.isSelected();
        if (old && !this._$5994) {
            for (LoggingEvent e : this._$30945) {
                this.log(e);
            }
            this._$30945.clear();
        }
    }

    void jButtonSaveAs_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(this._$6388.getProperty(CFG_EXPORT_PATH, "")));
        fc.setFileSelectionMode(0);
        if (fc.showSaveDialog(this) == 0) {
            Object[] options;
            int n;
            this._$6388.put(CFG_EXPORT_PATH, fc.getSelectedFile().getPath());
            if (fc.getSelectedFile().exists() && (n = JOptionPane.showOptionDialog(this, "File already exists. Overwrite it?", "Confirm Overwrite", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) == 1) {
                return;
            }
            try {
                int n2 = this.saveToFile(fc.getSelectedFile());
                if (n2 != 1) {
                    this._$14253.setMessage("" + n2 + " records written to " + fc.getSelectedFile().getPath());
                } else {
                    this._$14253.setMessage("One record written to " + fc.getSelectedFile().getPath());
                }
            }
            catch (IOException iox) {
                this._$14253.setMessage("Cannot write file " + fc.getSelectedFile() + ": " + iox.getMessage());
            }
        }
    }

    public synchronized int saveToFile(File f) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        for (int i = 0; i < this.model.getNumRows(); ++i) {
            StringBuffer buf = new StringBuffer();
            String d = _$30932.format((Date)this.model.getTableRowLabel(i));
            buf.append(d);
            buf.append(" ");
            buf.append(this.model.getTableDataItem(i, 0).toString());
            buf.append(" ");
            buf.append(this.model.getTableDataItem(i, 1).toString());
            buf.append(" ");
            int plen = buf.length();
            buf.append('\t');
            String s = this.model.getTableDataItem(i, 2).toString();
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                buf.append(st.nextToken());
                buf.append('\n');
                if (!st.hasMoreTokens()) continue;
                for (int j = 0; j < plen; ++j) {
                    buf.append(' ');
                }
                buf.append('\t');
            }
            os.write(buf.toString().getBytes());
        }
        os.flush();
        os.close();
        return this.model.getNumRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepaintEnabled(boolean repaint) {
        if (!this.table.isRepaintEnabled() && repaint) {
            LinkedList linkedList = this._$30945;
            synchronized (linkedList) {
                this.table.setRepaintEnabled(repaint);
                if (repaint) {
                    this.table.traverse(this.model.getNumRows() - 1, 0, false, false);
                }
            }
        } else {
            this.table.setRepaintEnabled(repaint);
            if (repaint) {
                this.table.traverse(this.model.getNumRows() - 1, 0, false, false);
            }
        }
    }

    void jButtonDelete_actionPerformed(ActionEvent e) {
        Collection c = this.table.getSelectedCells();
        if (c == null) {
            return;
        }
        JCCellRange[] r = new JCCellRange[c.size()];
        c.toArray(r);
        for (int i = 0; i < r.length; ++i) {
            TableUtils.setRangeAfterCopy(r[i]);
        }
        this.model.deleteRows(r[0].start_row, r[0].end_row - r[0].start_row + 1);
    }
}

