/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.lf;

import com.agentpp.util.UserConfigFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class LookAndFeelConfigPanel
extends JPanel {
    private static final String[][] _$4198 = new String[][]{{"tree.icon.AGENT-CAPABILITIES", "agentcaps16.gif"}, {"tree.icon.IMPORT.Module", "importmodule16.gif"}, {"tree.icon.MODULE-COMPLIANCE", "compliance16.gif"}, {"tree.icon.MODULE-IDENTITY", "module16.gif"}, {"tree.icon.NOTIFICATION-TYPE", "notification16.gif"}, {"tree.icon.NOTIFICATION-GROUP", "notifygroup16.gif"}, {"tree.icon.OBJECT-GROUP", "group16.gif"}, {"tree.icon.OBJECT-TYPE.Column", "column16.gif"}, {"tree.icon.OBJECT-TYPE.Scalar", "scalar16.gif"}, {"tree.icon.OBJECT-TYPE.Table", "table16.gif"}, {"tree.icon.OBJECT-TYPE.TableEntry", "tablerow16.gif"}, {"tree.icon.TEXTUAL-CONVENTION", "textualconvention16.gif"}, {"tree.icon.TRAP-TYPE", "notification16.gif"}, {"tree.icon.IMPORT.Object", "importobject16.gif"}, {"tree.icon.OBJECT-IDENTITY", "identity16.gif"}, {"tree.icon.INSTANCE", "instance16.gif"}, {"tree.icon.INSTANCE_MUTABLE", "instance_mutable16.gif"}};
    public static final String PROP_TREE_ICONS = "tree.icons";
    public static final String CFG_LOOK_AND_FEEL = "LookAndFeel";
    private static final String[][] _$4201 = new String[][]{{"Nimbus - Cross Platform", "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"}, {"Metal - Cross Platform", UIManager.getCrossPlatformLookAndFeelClassName()}, {"Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel"}, {"Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel"}, {"Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"}, {"Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel"}, {"System (Windows, Motif, etc.) [Default]", UIManager.getSystemLookAndFeelClassName()}};
    private Border _$4204;
    private TitledBorder _$4205;
    private JComboBox _$4206 = new JComboBox();
    private GridBagLayout _$4207 = new GridBagLayout();
    private UserConfigFile _$4208;
    private DefaultComboBoxModel _$4209 = new DefaultComboBoxModel();
    private JLabel _$4210 = new JLabel();
    JCheckBox useLookAndFeelTreeIcons = new JCheckBox();
    public boolean activateCustomTreeIcons;
    private int _$4213 = 1;

    public LookAndFeelConfigPanel(boolean activateCustomTreeIcons) {
        this.activateCustomTreeIcons = activateCustomTreeIcons;
        Class<?> nimbus = null;
        try {
            nimbus = Class.forName("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            if (nimbus != null) {
                this._$4213 = 0;
            }
        }
        catch (ClassNotFoundException ex1) {
            // empty catch block
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LookAndFeelConfigPanel() {
        this(false);
    }

    public LookAndFeelConfigPanel(UserConfigFile config) {
        this(false);
        this.setConfig(config);
    }

    public LookAndFeelConfigPanel(UserConfigFile config, boolean activateCustomTreeIcons) {
        this(activateCustomTreeIcons);
        this.setConfig(config);
    }

    void jbInit() throws Exception {
        this._$4206.setEditable(true);
        this._$4204 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$4205 = new TitledBorder(this._$4204, "Look & Feel");
        this.setBorder(this._$4205);
        this.setLayout(this._$4207);
        this._$4210.setText("*Changes will take effect after application restart.");
        this.useLookAndFeelTreeIcons.setToolTipText("If not checked node icons in the MIB tree reflect the object's type");
        this.useLookAndFeelTreeIcons.setText("Use SMI object type specific tree icons");
        this.useLookAndFeelTreeIcons.setSelected(true);
        this.add((Component)this._$4206, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._$4210, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        if (this.activateCustomTreeIcons) {
            this.add((Component)this.useLookAndFeelTreeIcons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        }
    }

    public void setConfig(UserConfigFile config) {
        this._$4208 = config;
        this._$4209.removeAllElements();
        for (int i = this._$4213; i < _$4201.length; ++i) {
            this._$4209.addElement(_$4201[i][0]);
        }
        this._$4206.setModel(this._$4209);
        String lf = config.get(CFG_LOOK_AND_FEEL, _$4201[0][1]);
        boolean found = false;
        for (int i = this._$4213; i < _$4201.length; ++i) {
            if (!lf.equals(_$4201[i][1])) continue;
            this._$4206.setSelectedIndex(i - this._$4213);
            found = true;
            break;
        }
        if (!found) {
            this._$4206.getEditor().setItem(lf);
        }
        this.useLookAndFeelTreeIcons.setSelected(config.getBoolean(PROP_TREE_ICONS, this.activateCustomTreeIcons));
    }

    public static final void setTreeIconConfig(UserConfigFile config) {
        for (int i = 0; i < _$4198.length; ++i) {
            config.put(_$4198[i][0], _$4198[i][1]);
        }
    }

    public void save() {
        this._$4208.putBoolean(PROP_TREE_ICONS, this.useLookAndFeelTreeIcons.isSelected());
        if (this.useLookAndFeelTreeIcons.isSelected()) {
            LookAndFeelConfigPanel.setTreeIconConfig(this._$4208);
        } else {
            for (int i = 0; i < _$4198.length; ++i) {
                this._$4208.remove(_$4198[i][0]);
            }
        }
        String lf = this._$4206.getSelectedItem().toString();
        for (int i = this._$4213; i < _$4201.length; ++i) {
            if (!lf.equals(_$4201[i][0])) continue;
            this._$4208.put(CFG_LOOK_AND_FEEL, _$4201[i][1]);
            return;
        }
        this._$4208.put(CFG_LOOK_AND_FEEL, lf);
    }
}

