/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.klg.jclass.field.JCComboField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SearchPanel
extends JPanel
implements SearchConfig {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelSearch = new JLabel();
    ButtonGroup buttonGroupSearch = new ButtonGroup();
    JRadioButton all = new JRadioButton();
    JLabel jLabelSearchFor = new JLabel();
    JLabel jLabelReplaceWith = new JLabel();
    JCheckBox jCheckBoxCase = new JCheckBox();
    JCComboField searchExpression = new JCComboField(String.class);
    JCComboField replaceExpression = new JCComboField(String.class);
    Vector buttons = new Vector();
    boolean replaceEnabled = false;

    public SearchPanel() {
        this(false);
    }

    public SearchPanel(boolean replaceEnabled) {
        this.replaceEnabled = replaceEnabled;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.all.setSelected(true);
        this.searchExpression.setModel(new DefaultComboBoxModel());
        this.replaceExpression.setModel(new DefaultComboBoxModel());
    }

    public void setSearchCategories(String[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            JRadioButton cat = new JRadioButton(categories[i]);
            this.buttonGroupSearch.add(cat);
            this.buttons.addElement(cat);
            this.add((Component)cat, new GridBagConstraints(1, 3 + this.buttons.size(), 1, 1, 0.9, 1.0, 11, 2, new Insets(0, 10, i + 1 < categories.length ? 0 : 10, 10), 0, 0));
        }
    }

    public void setSearchOptionsEnabled(boolean[] enabled) {
        for (int i = 0; i < this.buttons.size() && i < enabled.length; ++i) {
            ((JRadioButton)this.buttons.get(i)).setEnabled(enabled[i]);
        }
    }

    public String getSearchExpression() {
        if (this.searchExpression.getSelectedItem() != null) {
            return this.searchExpression.getSelectedItem().toString();
        }
        return "";
    }

    public void setSearchExpressions(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            this.searchExpression.addItem(en.nextElement());
        }
    }

    public String getReplaceExpression() {
        if (this.replaceExpression.getSelectedItem() != null) {
            return this.replaceExpression.getSelectedItem().toString();
        }
        return "";
    }

    public void setReplaceExpressions(Vector v) {
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            this.replaceExpression.addItem(en.nextElement());
        }
    }

    public Vector getSearchExpressions() {
        Vector<Object> v = new Vector<Object>(this.searchExpression.getItemCount() + 1);
        if (this.searchExpression.getSelectedItem() == null) {
            return null;
        }
        int max = Math.min(this.searchExpression.getItemCount(), 10);
        for (int i = 0; i < max; ++i) {
            v.addElement(this.searchExpression.getItemAt(i));
        }
        v.removeElement(this.searchExpression.getSelectedItem());
        v.insertElementAt(this.searchExpression.getSelectedItem(), 0);
        return v;
    }

    public Vector getReplaceExpressions() {
        Vector<Object> v = new Vector<Object>(this.replaceExpression.getItemCount() + 1);
        if (this.replaceExpression.getSelectedItem() == null) {
            return null;
        }
        int max = Math.min(this.replaceExpression.getItemCount(), 10);
        for (int i = 0; i < max; ++i) {
            v.addElement(this.replaceExpression.getItemAt(i));
        }
        v.removeElement(this.replaceExpression.getSelectedItem());
        v.insertElementAt(this.replaceExpression.getSelectedItem(), 0);
        return v;
    }

    void jbInit() throws Exception {
        this.searchExpression.setSelectOnEnter(true);
        this.jLabelSearch.setText("Search:");
        this.setLayout(this.gridBagLayout1);
        this.all.setText("All");
        this.jLabelSearchFor.setText("Search Expression:");
        this.jLabelReplaceWith.setText("Replace With:");
        this.jCheckBoxCase.setText("Ignore Case");
        this.jCheckBoxCase.setActionCommand("jCheckBoxCase");
        this.searchExpression.setEditable(true);
        this.add((Component)this.searchExpression, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.all, new GridBagConstraints(1, 3, 1, 1, 0.9, 1.0, 11, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.add((Component)this.jCheckBoxCase, new GridBagConstraints(1, 2, 1, 1, 0.9, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelSearchFor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelSearch, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        if (this.replaceEnabled) {
            this.add((Component)this.jLabelReplaceWith, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this.replaceExpression, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        }
        this.buttonGroupSearch.add(this.all);
    }

    public void setIgnoreCase(boolean ignore) {
        this.jCheckBoxCase.setSelected(ignore);
    }

    public boolean isIgnoreCase() {
        return this.jCheckBoxCase.isSelected();
    }

    public boolean[] getSearchOptions() {
        boolean[] flags = new boolean[this.buttons.size() + 1];
        flags[0] = this.all.isSelected();
        for (int i = 0; i < this.buttons.size(); ++i) {
            flags[i + 1] = ((JRadioButton)this.buttons.elementAt(i)).isSelected();
        }
        return flags;
    }

    public int getSearchConfig() {
        boolean[] flags = this.getSearchOptions();
        int r = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (!flags[i]) continue;
            r |= 1 << i;
        }
        return r;
    }

    public void setSearchConfig(int opt) {
        for (int i = 0; i < this.buttons.size() + 1; ++i) {
            boolean select;
            boolean bl = select = (opt & 1 << i) > 0;
            if (!select) continue;
            if (i <= 0) {
                this.all.setSelected(true);
                continue;
            }
            if (i - 1 >= this.buttons.size()) continue;
            ((JRadioButton)this.buttons.elementAt(i - 1)).setSelected(true);
        }
    }
}

