/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.Regex;
import com.agentpp.util.ThreadPool;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SearchMIBRepository
extends JPanel
implements Runnable,
JCCellDisplayListener {
    private static final String[] _$18891 = new String[]{"MIB Module", "Object Name", "OID", "Type"};
    private static final int _$18892 = 2;
    private static final int _$18893 = 1;
    private static final int _$18894 = 0;
    private SearchConfig _$18895;
    private Regex _$6719;
    private String _$18896 = null;
    private JFrame _$6733;
    private RepositoryManager _$18897;
    private BorderLayout _$13010 = new BorderLayout();
    private JPanel _$18898 = new JPanel();
    private JPanel _$18899 = new JPanel();
    private JProgressBar _$18900 = new JProgressBar();
    private JLabel _$18901 = new JLabel();
    private GridBagLayout _$12999 = new GridBagLayout();
    private ExtendedListTable _$3889 = new ExtendedListTable();
    private BorderLayout _$13012 = new BorderLayout();
    private JCVectorDataSource _$11503 = new JCVectorDataSource();
    public volatile boolean cancel = false;
    private JLabel _$13000 = new JLabel();
    private JLabel _$12447 = new JLabel();
    private int _$4845 = 0;
    private JLabel _$18902 = new JLabel();
    private JLabel _$18903 = new JLabel();
    private Runnable _$18904;

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel) {
        this(frame, repMan, searchExpression, searchPanel, null);
    }

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel, String moduleScope) {
        this._$6733 = frame;
        this._$18897 = repMan;
        this._$18895 = searchPanel;
        this._$6719 = searchExpression;
        this._$18896 = moduleScope;
        this._$11503.setNumColumns(_$18891.length);
        this._$11503.setColumnLabels(_$18891);
        this._$11503.setNumRows(10);
        this._$3889.setDataSource(this._$11503);
        this._$3889.setPopupMenuEnabled(false);
        this._$3889.setCharWidth(-1, 5);
        this._$3889.setTraverseCycle(false);
        this._$3889.addCellDisplayListener(this);
        try {
            this._$6757();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFinishCallback(Runnable finishCallback) {
        this._$18904 = finishCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadPool threadPool = ThreadPool.create("SearchMIBRepository", Runtime.getRuntime().availableProcessors());
        this._$4845 = 0;
        this._$11503.setNumRows(0);
        Object[] modules = null;
        try {
            modules = this._$18897.getModuleNames();
        }
        catch (IOException ex) {
            this._$12447.setText("Failed to access MIB repository: " + ex.getMessage());
            return;
        }
        this._$18900.setMaximum(0);
        this._$18900.setMaximum(modules.length - 1);
        this._$18900.setStringPainted(true);
        Arrays.sort(modules);
        for (int i = 0; i < modules.length && !this.cancel; ++i) {
            this._$12447.setText((String)modules[i]);
            this._$18900.setValue(i);
            Object moduleName = modules[i];
            threadPool.execute(new Runnable((String)moduleName){
                final /* synthetic */ String val$moduleName;
                {
                    this.val$moduleName = string;
                }

                public void run() {
                    try {
                        MIBObject[] objects = SearchMIBRepository.this._$18897.getObjects(this.val$moduleName);
                        MIBRepository rep = new MIBRepository(objects);
                        objects = SearchMIBRepository.this._$18897.getImportedObjects(this.val$moduleName);
                        rep.addAllObjects(objects);
                        SearchMIBRepository.this._$18909(this.val$moduleName, rep);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            });
        }
        while (!threadPool.isIdle()) {
            try {
                ThreadPool i = threadPool;
                synchronized (i) {
                    threadPool.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        threadPool.stop();
        this._$12447.setText("Search complete!");
        if (this._$18904 != null) {
            SwingUtilities.invokeLater(this._$18904);
        }
    }

    public TreeMap getSelectedObjects() {
        int[] rows = TableUtils.getSelectedRows(this._$3889);
        TreeMap<Object, Object> h = new TreeMap<Object, Object>();
        for (int i = 0; i < rows.length; ++i) {
            h.put(this._$11503.getTableDataItem(rows[i], 1), this._$11503.getTableDataItem(rows[i], 0));
        }
        return h;
    }

    private synchronized boolean _$18910(MIBRepository rep, Regex expression, MIBObject o, boolean[] flags) {
        MIBModule module;
        if (flags[0] && (module = rep.getModule(o.getModuleID())) != null && expression.match(o.toSMI(1, module.getSMIVersion(), rep, "\n"))) {
            return true;
        }
        if ((flags[0] || flags[2]) && o.getName() != null && expression.match(o.getName())) {
            return true;
        }
        if ((flags[0] || flags[1]) && o.getOid() != null && expression.match(o.getOid().toString())) {
            return true;
        }
        if ((flags[0] || flags[3]) && o.getDescription() != null && expression.match(o.getDescription())) {
            return true;
        }
        if (flags[0] || flags.length > 4 && flags[4]) {
            List refs = this._$18914(rep, o);
            for (String ref : refs) {
                if (!expression.match(ref)) continue;
                return true;
            }
        }
        return false;
    }

    private List _$18914(MIBRepository rep, MIBObject o) {
        LinkedList<String> refs;
        block10: {
            MIBAgentCaps ac;
            block11: {
                block9: {
                    refs = new LinkedList<String>();
                    if (!(o instanceof MIBModule)) break block9;
                    MIBModule m = (MIBModule)o;
                    if (!m.hasImports()) break block10;
                    for (int i = 0; i < m.getImportsVector().size(); ++i) {
                        MIBImport imp = (MIBImport)m.getImportsVector().get(i);
                        if (this._$18896 != null && !imp.getSource().equals(this._$18896)) continue;
                        refs.addAll(imp.getImportsVector());
                    }
                    break block10;
                }
                if (!(o instanceof MIBCompliance)) break block11;
                MIBCompliance c = (MIBCompliance)o;
                if (c.getModules() == null) break block10;
                for (MIBComplianceModule cm : c.getModules()) {
                    String moduleName = cm.getModuleName();
                    if (!cm.hasModuleName()) {
                        moduleName = rep.getModuleName(o.getModuleID());
                    }
                    if (this._$18896 != null && !moduleName.equals(this._$18896)) continue;
                    if (cm.hasMandatory()) {
                        refs.addAll(cm.getMandatoryVector());
                    }
                    if (!cm.hasVariations()) continue;
                    for (MIBVariation var : cm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
                break block10;
            }
            if (o instanceof MIBAgentCaps && (ac = (MIBAgentCaps)o).getModules() != null) {
                for (MIBSupportedModule sm : ac.getModules()) {
                    String moduleName = sm.getSupports();
                    if (sm.getSupports() == null) {
                        moduleName = rep.getModuleName(o.getModuleID());
                    }
                    if (this._$18896 != null && !moduleName.equals(this._$18896) || !sm.hasVariations()) continue;
                    for (MIBVariation var : sm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
            }
        }
        return refs;
    }

    private void _$18909(String moduleName, MIBRepository rep) {
        Integer moduleID = null;
        if (rep.getModule(moduleName) != null) {
            moduleID = rep.getModule(moduleName).getModuleID();
        }
        Enumeration<? extends MIBObject> en = rep.objectsByName();
        while (en.hasMoreElements()) {
            MIBObject o = en.nextElement();
            if (!o.getModuleID().equals(moduleID) || !this._$18910(rep, this._$6719, o, this._$18895.getSearchOptions())) continue;
            ++this._$4845;
            if (this._$4845 == 1) {
                this._$18903.setText("" + this._$4845 + " match.");
            } else {
                this._$18903.setText("" + this._$4845 + " matches.");
            }
            final Vector<Object> row = new Vector<Object>();
            row.add(moduleName);
            row.add(o);
            row.add(o.getOid());
            row.add(o.getTypeString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchMIBRepository.this._$11503.addRow(Integer.MAX_VALUE, new Integer(SearchMIBRepository.this._$11503.getNumRows() + 1), row);
                }
            });
        }
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this._$18897 = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this._$18897;
    }

    public SearchMIBRepository() {
        try {
            this._$6757();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _$6757() throws Exception {
        this.setLayout(this._$13010);
        this._$18901.setText("Progress:");
        this._$18899.setLayout(this._$12999);
        this._$18900.setStringPainted(true);
        this._$18898.setLayout(this._$13012);
        this._$13000.setText("Searching:");
        this._$18902.setText("Found:");
        this._$18903.setText("0 matches.");
        this.add((Component)this._$18898, "Center");
        this._$18898.add((Component)this._$3889, "Center");
        this.add((Component)this._$18899, "North");
        this._$18899.add((Component)this._$18901, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$18899.add((Component)this._$18900, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this._$18899.add((Component)this._$13000, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this._$18899.add((Component)this._$12447, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this._$18899.add((Component)this._$18902, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._$18899.add((Component)this._$18903, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void cellDisplay(JCCellDisplayEvent e) {
        if (e.getColumn() == 1 && e.getCellData() instanceof MIBObject) {
            MIBObject o = (MIBObject)e.getDisplayData();
            e.setDisplayData(o.getName());
        }
    }
}

