/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class MemoryStatus
extends JComponent
implements ActionListener {
    private Timer _$520;

    public MemoryStatus() {
        this.setDoubleBuffered(true);
        Border border = BorderFactory.createLoweredBevelBorder();
        this.setBorder(border);
        Dimension dim = this.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(UIManager.getFont("Label.font"));
        dim.width += fm.stringWidth("999Mb/999Mb");
        dim.height = fm.getHeight() + fm.getDescent();
        this.setPreferredSize(dim);
    }

    public void addNotify() {
        super.addNotify();
        this._$520 = new Timer(2000, this);
        this._$520.start();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this._$520.stop();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public String getToolTipText() {
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int)(runtime.freeMemory() / 1024L);
        int totalMemory = (int)(runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        Integer[] args = new Integer[]{new Integer(usedMemory), new Integer(totalMemory)};
        return MessageFormat.format("Java heap memory used {0}Kb/{1}Kb", args);
    }

    public void actionPerformed(ActionEvent evt) {
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Insets insets = this.getBorder().getBorderInsets(this);
        Runtime runtime = Runtime.getRuntime();
        int freeMemory = (int)(runtime.freeMemory() / 1024L);
        int totalMemory = (int)(runtime.totalMemory() / 1024L);
        int usedMemory = totalMemory - freeMemory;
        int width = this.getWidth() - insets.left - insets.right;
        float fraction = (float)usedMemory / (float)totalMemory;
        Color background = UIManager.getColor("ProgressBar.selectionBackground");
        if (background != null) {
            g.setColor(background);
        }
        g.fillRect(insets.left, insets.top, (int)((float)width * fraction), this.getHeight() - insets.top - insets.bottom);
        String str = usedMemory / 1024 + "Mb/" + totalMemory / 1024 + "Mb";
        FontMetrics fm = g.getFontMetrics();
        Graphics g2 = g.create();
        g2.setClip(insets.left, insets.top, (int)((float)width * fraction), this.getHeight() - insets.top - insets.bottom);
        Color foreground = UIManager.getColor("ProgressBar.selectionForeground");
        if (background != null && background.equals(foreground)) {
            foreground = UIManager.getColor("ProgressBar.foreground");
        }
        if (foreground != null) {
            g2.setColor(foreground);
        }
        g2.drawString(str, insets.left + (width - fm.stringWidth(str)) / 2, insets.top + fm.getAscent());
        g2.dispose();
        g2 = g.create();
        g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.getWidth() - insets.left - (int)((float)width * fraction), this.getHeight() - insets.top - insets.bottom);
        g2.setColor(this.getForeground());
        g2.drawString(str, insets.left + (width - fm.stringWidth(str)) / 2, insets.top + fm.getAscent());
        g2.dispose();
    }
}

