/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ParserLog;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.mib.event.MIBModuleEvent;
import com.agentpp.mib.event.MIBModuleListener;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowDialogLater;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class MIBCompiler {
    private static final String[] _$2822 = new String[]{"ZIP"};
    static ExampleFileFilter filter = new ExampleFileFilter(_$2822);
    private static boolean _$2824;

    public static void compileMIBs(UserConfigFile config, MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, UpdateMode updateExistant) {
        MIBCompiler.compileMIBs(config, listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, false);
    }

    public static void compileMIBs(UserConfigFile config, MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, UpdateMode updateExistant, boolean compileLeniently) {
        MIBCompiler.compileMIBs(config, listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, compileLeniently, false);
    }

    public static List compileMIBs(UserConfigFile config, final MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, UpdateMode updateExistant, boolean compileLeniently, boolean silent) {
        ArrayList<CompilationResult> results = new ArrayList<CompilationResult>();
        StandardDialog sd = null;
        ParserLog pd = null;
        if (frame != null) {
            sd = new StandardDialog((Frame)frame, "Compiler Log", false, false);
            pd = new ParserLog(config, frame, (MIBImporter)((Object)frame));
            pd.setPreferredSize(new Dimension(800, 500));
            pd.setLookupEnabled(_$2824);
        }
        boolean errorsDetected = false;
        int total = 0;
        int ok = 0;
        try {
            int k;
            ProgressMonitor pm = null;
            if (frame != null) {
                pm = new ProgressMonitor(frame, "Sorting...", files[0].getPath(), 0, files.length);
            }
            ArrayList<ModuleInfo> v = new ArrayList<ModuleInfo>(files.length + 1);
            for (int j = 0; !(pm != null && pm.isCanceled() || j >= files.length); ++j) {
                try {
                    ModuleInfo[] info;
                    if (frame != null) {
                        SwingUtilities.invokeLater(new ProgressUpdater(pm, j, files[j].getPath()));
                    }
                    if (openZIPFiles && MIBCompiler._$2850(files[j])) {
                        ZipFile zipFile = new ZipFile(files[j]);
                        info = repMan.getModuleInfo(zipFile);
                    } else {
                        info = repMan.getModuleInfo(files[j]);
                    }
                    for (int k2 = 0; k2 < info.length; ++k2) {
                        v.add(info[k2]);
                    }
                    continue;
                }
                catch (Exception ex) {
                    ModuleInfo inf = new ModuleInfo("invalid ");
                    inf.path = files[j];
                    v.add(inf);
                }
            }
            if (pm != null && pm.isCanceled()) {
                return results;
            }
            ModuleInfo[] existant = repMan.getModuleInfos();
            if (updateExistant != UpdateMode.updateAlways) {
                ModuleInfo inf;
                for (int i = 0; i < existant.length; ++i) {
                    for (int j = 0; j < v.size(); ++j) {
                        inf = (ModuleInfo)v.get(j);
                        if (!inf.getModuleName().equals(existant[i].getModuleName()) || updateExistant == UpdateMode.updateIfNewer && inf.getLastUpdated() != null && (inf.getLastUpdated() == null || existant[i].getLastUpdated() != null && (existant[i].getLastUpdated() == null || inf.getLastUpdated().compareTo(existant[i].getLastUpdated()) > 0))) continue;
                        v.remove(j);
                        --j;
                    }
                }
                HashMap<String, ModuleInfo> h = new HashMap<String, ModuleInfo>(v.size() + 10);
                for (int j = 0; j < v.size(); ++j) {
                    inf = (ModuleInfo)v.get(j);
                    if (h.containsKey(inf.getModuleName())) {
                        ModuleInfo ex;
                        if (updateExistant == UpdateMode.updateIfNewer && ((ex = (ModuleInfo)h.get(inf.getModuleName())).getLastUpdated() == null && inf.getLastUpdated() != null || ex.getLastUpdated() != null && inf.getLastUpdated() != null && ex.getLastUpdated().compareTo(inf.getLastUpdated()) < 0)) {
                            v.remove(ex);
                            --j;
                            continue;
                        }
                        v.remove(j);
                        --j;
                        continue;
                    }
                    h.put(inf.getModuleName(), inf);
                }
            }
            ModuleInfo[] list = new ModuleInfo[v.size()];
            v.toArray(list);
            v = null;
            ModuleInfoSorter s = new ModuleInfoSorter(list);
            s.setPool(existant);
            s.setBackupPool(repMan.getBuiltinModuleNames());
            s.sort();
            ModuleInfo[] sorted = s.getSortedList();
            ModuleInfo[] failed = s.getFailedList();
            files = new File[sorted.length + failed.length];
            Object[][] zipFiles = new Object[sorted.length + failed.length][];
            for (k = 0; k < sorted.length; ++k) {
                files[k] = sorted[k].path;
                zipFiles[k] = sorted[k].userObject instanceof Object[] ? (Object[])sorted[k].userObject : null;
            }
            while (k < files.length) {
                int p = k - sorted.length;
                files[k] = failed[p].path;
                zipFiles[k] = failed[p].userObject instanceof Object[] ? (Object[])failed[p].userObject : null;
                ++k;
            }
            if (frame != null) {
                SwingUtilities.invokeLater(new EventTrigger(pm));
                pm = new ProgressMonitor(frame, "Compiling...", files[0].getPath(), 0, files.length);
            }
            HashSet<Object> parsed = new HashSet<Object>(files.length + 10);
            ProgressUpdater progressUpdater = null;
            for (int j = 0; !(pm != null && pm.isCanceled() || j >= files.length); ++j) {
                ZipEntry entry = null;
                if (zipFiles[j] != null) {
                    String name = files[j].getPath();
                    entry = (ZipEntry)zipFiles[j][1];
                    if (entry == null && pd != null) {
                        pd.addResult(new ZipReference(entry, (ZipFile)zipFiles[j][0]), new SMIParseException(name, 10), new Vector(1));
                        continue;
                    }
                }
                try {
                    int i;
                    Vector<String> m;
                    ModuleInfo[] info;
                    if (entry != null) {
                        if (parsed.contains(entry.getName())) continue;
                        parsed.add(entry.getName());
                        ++total;
                        info = compileLeniently ? repMan.addModulesLeniently(((ZipFile)zipFiles[j][0]).getInputStream(entry), files[j].getPath()) : repMan.addModules(((ZipFile)zipFiles[j][0]).getInputStream(entry), files[j].getPath());
                        ++ok;
                        m = new Vector();
                        for (i = 0; i < info.length; ++i) {
                            m.addElement(info[i].moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m, 4));
                            }
                        });
                        if (pd != null) {
                            pd.addResult(new ZipReference(entry, (ZipFile)zipFiles[j][0]), null, m);
                        }
                        results.add(new CompilationResult(entry.getName(), null, m));
                    } else {
                        if (parsed.contains(files[j])) continue;
                        ++total;
                        parsed.add(files[j]);
                        info = compileLeniently ? repMan.addModulesLeniently(files[j]) : repMan.addModules(files[j]);
                        ++ok;
                        m = new Vector<String>();
                        for (i = 0; i < info.length; ++i) {
                            m.add(info[i].moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m, 4));
                            }
                        });
                        if (pd != null) {
                            pd.addResult(files[j], null, m);
                        }
                    }
                    if (progressUpdater != null && !progressUpdater.isFinished()) {
                        progressUpdater._$2897 = files[j].getPath();
                        progressUpdater._$2877 = j;
                        continue;
                    }
                    if (pm == null) continue;
                    progressUpdater = new ProgressUpdater(pm, j, files[j].getPath());
                    SwingUtilities.invokeLater(progressUpdater);
                    continue;
                }
                catch (SMIParseException pex) {
                    pex.freeUnusedTokens();
                    if (pd != null) {
                        if (zipFiles[j] != null) {
                            pd.addResult(new ZipReference(entry, (ZipFile)zipFiles[j][0]), pex, null);
                        } else {
                            pd.addResult(files[j], pex, null);
                        }
                    }
                    results.add(new CompilationResult(zipFiles[j] != null ? entry.getName() : files[j].getPath(), pex, null));
                }
            }
            if (pm != null) {
                SwingUtilities.invokeLater(new EventTrigger(pm));
            }
            errorsDetected = ok < total;
            String message = errorsDetected ? "Compilation failed for " + (total - ok) + " out of " + total + " MIB modules." : "Successfully compiled all " + total + " MIB modules.";
            statusBar.setMessage(message);
        }
        catch (IOException iox) {
            String s = "Cannot open file: " + iox.getMessage();
            statusBar.setMessage(s);
        }
        if (frame != null && !silent) {
            Object[] options;
            if (errorsDetected) {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, new String[]{"Compilation failed for " + (total - ok) + " out of " + total + " MIB modules.", "Click on 'Details...' to view the compiler log to correct errors."}, "Compilation Errors", 0, 0, null, options, options[1]) == 1) {
                    sd.setCenterPanel(pd);
                    pd.refresh();
                    sd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(sd));
                }
            } else {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, "Successfully compiled all " + total + " MIB modules.", "Compilation Success", 0, 1, null, options, options[0]) == 1) {
                    sd.setCenterPanel(pd);
                    pd.refresh();
                    sd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(sd));
                }
            }
        }
        return results;
    }

    private static boolean _$2850(File f) {
        return f.isFile() && filter.accept(f);
    }

    public static void setLookupEnabled(boolean parserLookupEnabled) {
        _$2824 = parserLookupEnabled;
    }

    public static class ZipReference
    implements Comparable {
        public ZipFile file;
        public ZipEntry entry;

        public ZipReference(ZipEntry entry, ZipFile file) {
            this.file = file;
            this.entry = entry;
        }

        public String toString() {
            return this.file.getName();
        }

        public int compareTo(Object o) {
            if (o instanceof File) {
                return this.toString().compareTo(o.toString());
            }
            if (o instanceof ZipReference) {
                int c = this.file.getName().compareTo(((ZipReference)o).file.getName());
                if (c == 0) {
                    return this.entry.getName().compareTo(((ZipReference)o).entry.getName());
                }
                return c;
            }
            throw new ClassCastException();
        }
    }

    public static class EventTrigger
    implements Runnable {
        private ProgressMonitor _$2842;

        public EventTrigger(ProgressMonitor pm) {
            this._$2842 = pm;
        }

        public void run() {
            this._$2842.close();
        }
    }

    public static class ProgressUpdater
    implements Runnable {
        private int _$2877;
        private String _$2897;
        private ProgressMonitor _$2842;
        private boolean _$2921;

        public ProgressUpdater(ProgressMonitor pm, int p, String note) {
            this._$2842 = pm;
            this._$2897 = note;
            this._$2877 = p;
        }

        public void run() {
            this._$2921 = true;
            this._$2842.setNote(this._$2897);
            this._$2842.setProgress(this._$2877);
        }

        public boolean isFinished() {
            return this._$2921;
        }
    }

    public static class CompilationResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String _$2915;
        private SMIParseException _$2898;
        private List _$2916;

        public CompilationResult(String fname, SMIParseException pex, List modules) {
            this._$2915 = fname;
            this._$2898 = pex;
            this._$2916 = modules;
        }

        public String getFilename() {
            return this._$2915;
        }

        public SMIParseException getParseException() {
            return this._$2898;
        }

        public List getModules() {
            return this._$2916;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateMode {
        addNewOnly,
        updateIfNewer,
        updateAlways;

    }
}

