/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro.util;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import java.util.Vector;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class IndexConverter {
    public static Variable getIndexVariable(IndexStruct indexStruct, ObjectID objectID) {
        try {
            switch (indexStruct.baseType) {
                case 1: {
                    if (indexStruct.impliedLength || indexStruct.minLength == indexStruct.maxLength) {
                        OctetString octetString = new OctetString(objectID.asByteArray());
                        return octetString;
                    }
                    ObjectID objectID2 = objectID.getSuffix(objectID.size() - 1);
                    return new OctetString(objectID2.asByteArray());
                }
                case 0: {
                    return new Integer32((int)objectID.getLastSubID() & 0xFFFFFFFF);
                }
                case 9: {
                    return new TimeTicks(objectID.getLastSubID());
                }
                case 5: {
                    return new IpAddress(objectID.toString());
                }
                case 12: {
                    String string = objectID.toString();
                    return new IpAddress(string.substring(string.indexOf(".") + 1));
                }
            }
            if (indexStruct.impliedLength || indexStruct.minLength == indexStruct.maxLength) {
                return new OID(objectID.toString());
            }
            return new OID(objectID.getSuffix(objectID.size() - 1).toString());
        }
        catch (Exception exception) {
            return new OID(objectID.toString());
        }
    }

    public static Variable[] getIndexVariables(IndexStruct[] indexStructArray, ObjectID[] objectIDArray) {
        int n = Math.min(indexStructArray.length, objectIDArray.length);
        Variable[] variableArray = new Variable[n];
        for (int i = 0; i < n; ++i) {
            variableArray[i] = IndexConverter.getIndexVariable(indexStructArray[i], objectIDArray[i]);
        }
        return variableArray;
    }

    public static String getIndexString(ValueConverter valueConverter, IndexStruct indexStruct, ObjectID objectID) {
        Object object = valueConverter.toNative(IndexConverter.getIndexVariable(indexStruct, objectID), true);
        if (object == null) {
            return "?";
        }
        return object.toString();
    }

    public static String getIndexString(ValueConverter[] valueConverterArray, IndexStruct[] indexStructArray, ObjectID[] objectIDArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < indexStructArray.length && i < objectIDArray.length && i < valueConverterArray.length; ++i) {
            stringBuffer.append(IndexConverter.getIndexString(valueConverterArray[i], indexStructArray[i], objectIDArray[i]));
            if (i + 1 >= indexStructArray.length || i + 1 >= objectIDArray.length || i + 1 >= valueConverterArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static ValueConverter[] getIndexValueConverter(MIBRepository mIBRepository, MIBObjectType mIBObjectType) {
        if (!mIBObjectType.isTable()) {
            return null;
        }
        Vector vector = mIBRepository.getColumnarObjectsOfTable(mIBObjectType, true, false);
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i = 0; i < valueConverterArray.length; ++i) {
            MIBObjectType mIBObjectType2 = (MIBObjectType)vector.elementAt(i);
            MIBTextualConvention mIBTextualConvention = mIBRepository.getEffectiveSyntax(mIBObjectType2.getSyntax());
            valueConverterArray[i] = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        return valueConverterArray;
    }
}

