/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro.agent;

import com.agentpp.agenpro.agent.XMLUtils;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.snmp.ValueConverter;
import com.objectspace.jgl.Pair;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOFilter;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBConfigXML {
    private static final LogAdapter _$1141 = LogFactory.getLogger("org.snmp4j.agent.config.xml");
    private MIBRepository _$436;
    private MOServer[] _$15826;

    public MIBConfigXML(MIBRepository mIBRepository, MOServer[] mOServerArray) {
        this._$436 = mIBRepository;
        this._$15826 = mOServerArray;
    }

    public boolean readConfig(InputStream inputStream, MOFilter mOFilter) {
        DOMDocument dOMDocument = null;
        try {
            dOMDocument = XMLUtils.readDOMDocument(inputStream, DOMDocumentFactory.getInstance());
            List list = ((DOMElement)dOMDocument.getDocumentElement()).elements("object");
            for (DOMElement dOMElement : list) {
                this.readObject(dOMElement, mOFilter);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void readObject(DOMElement dOMElement, MOFilter mOFilter) {
        String string = dOMElement.attributeValue("name");
        String string2 = dOMElement.attributeValue("module");
        List list = dOMElement.elements("context");
        String string3 = dOMElement.attributeValue("oid");
        OctetString[] octetStringArray = null;
        if (list.size() > 0) {
            octetStringArray = new OctetString[list.size()];
            int n = 0;
            for (Cloneable cloneable : list) {
                octetStringArray[n] = new OctetString(((DefaultElement)cloneable).getText());
                ++n;
            }
        } else {
            octetStringArray = new OctetString[1];
        }
        MIBObject mIBObject = null;
        mIBObject = string2 == null ? (string3 == null ? this._$436.getObject(string) : this._$436.getObject(new ObjectID(string3))) : this._$436.getObject(string2, string);
        if (mIBObject instanceof MIBObjectType) {
            MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
            if (mIBObjectType.isScalar()) {
                this._$24175(mIBObjectType, (DOMElement)dOMElement.element("scalar"), octetStringArray, mOFilter);
            } else if (!mIBObjectType.isColumnarObject()) {
                try {
                    Cloneable cloneable;
                    cloneable = new OID(mIBObjectType.getOid().asIntArray());
                    if (!mIBObjectType.isTable()) {
                        ((OID)cloneable).append(1);
                    }
                    for (int i = 0; i < octetStringArray.length; ++i) {
                        MOServer mOServer = this._$24176(octetStringArray[i]);
                        if (mOServer == null) {
                            _$1141.warn((Serializable)((Object)("No server found for context '" + octetStringArray + "' for object '" + string + "'.")));
                            return;
                        }
                        DefaultMOContextScope defaultMOContextScope = new DefaultMOContextScope(octetStringArray[i], (OID)cloneable, true, new OID((OID)cloneable).append(1), true);
                        ManagedObject managedObject = mOServer.lookup(new DefaultMOQuery(defaultMOContextScope, true));
                        if (!mOFilter.passesFilter(managedObject) || !(managedObject instanceof MOTable)) continue;
                        MOTable mOTable = (MOTable)managedObject;
                        if ("replace".equals(dOMElement.attributeValue("configType")) && mOTable.getModel() instanceof MOMutableTableModel) {
                            ((MOMutableTableModel)mOTable.getModel()).clear();
                        }
                        this._$24177(this._$436.getTableEntry(mIBObjectType), mOTable, dOMElement.elements("row"));
                    }
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                    objectIDFormatException.printStackTrace();
                }
            }
        } else if (mIBObject == null) {
            _$1141.warn((Serializable)((Object)("MIB definition for object '" + string + "' and module '" + string2 + "' not found, no data loaded.")));
        } else {
            _$1141.warn((Serializable)((Object)("MIB definition for object '" + string + "' and module '" + string2 + "' is not an OBJECT-TYPE, no data loaded.")));
        }
    }

    private void _$24177(MIBObjectType mIBObjectType, MOTable mOTable, List<DOMElement> list) {
        Vector vector = this._$436.getColumnarObjectsOfTable(mIBObjectType, true, false);
        Vector vector2 = this._$436.getColumnarObjectsOfTable(mIBObjectType, false, true);
        for (DOMElement dOMElement : list) {
            Object object;
            int n;
            Iterator<Object> iterator;
            List list2 = dOMElement.elements("i");
            OID oID = new OID();
            if (!dOMElement.hasAttribute("index")) {
                iterator = list2.iterator();
                for (n = 0; iterator.hasNext() && n < vector.size(); ++n) {
                    object = (DOMElement)iterator.next();
                    Variable variable = this._$24184((MIBObjectType)vector.get(n), (DOMElement)object);
                    boolean bl = false;
                    if (!iterator.hasNext() && mIBObjectType.getIndex().isImplied()) {
                        bl = true;
                    }
                    oID.append(variable.toSubIndex(bl));
                }
            } else {
                oID = new OID(dOMElement.attributeValue("index"));
            }
            iterator = mOTable.getModel().getRow(oID);
            object = dOMElement.attributeValue("configType");
            boolean bl = false;
            if (iterator == null && ("create".equals(object) || "update".equals(object) || object == null)) {
                iterator = mOTable.createRow(oID);
                bl = true;
            } else if (iterator != null && "delete".equals(object)) {
                mOTable.removeRow(oID);
                iterator = null;
            }
            if (iterator == null || !(iterator instanceof MOMutableTableRow)) continue;
            MOMutableTableRow mOMutableTableRow = (MOMutableTableRow)((Object)iterator);
            List list3 = dOMElement.elements("c");
            n = 0;
            for (DOMElement dOMElement2 : list3) {
                MIBObjectType mIBObjectType2 = null;
                if (n < vector2.size()) {
                    mIBObjectType2 = (MIBObjectType)vector2.get(n);
                }
                try {
                    Variable variable = this._$24184(mIBObjectType2, dOMElement2);
                    mOMutableTableRow.setValue(n, variable);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++n;
            }
            if (!bl) continue;
            mOTable.addRow(mOMutableTableRow);
        }
    }

    private MOServer _$24176(OctetString octetString) {
        for (int i = 0; i < this._$15826.length; ++i) {
            if (!this._$15826[i].isContextSupported(octetString)) continue;
            return this._$15826[i];
        }
        return null;
    }

    private void _$24175(MIBObjectType mIBObjectType, DOMElement dOMElement, OctetString[] octetStringArray, MOFilter mOFilter) {
        try {
            Variable variable = this._$24184(mIBObjectType, dOMElement);
            for (int i = 0; i < octetStringArray.length; ++i) {
                MOServer mOServer = this._$24176(octetStringArray == null ? null : octetStringArray[0]);
                if (mOServer == null) continue;
                OID oID = null;
                try {
                    oID = new OID(mIBObjectType.getOid().asIntArray());
                    oID.append(0);
                    DefaultMOContextScope defaultMOContextScope = new DefaultMOContextScope(octetStringArray[i], oID, true, oID, true);
                    ManagedObject managedObject = mOServer.lookup(new DefaultMOQuery(defaultMOContextScope, true));
                    if (!mOFilter.passesFilter(managedObject) || !(managedObject instanceof MOScalar)) continue;
                    ((MOScalar)managedObject).setValue(variable);
                    continue;
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                    objectIDFormatException.printStackTrace();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    private Variable _$24184(MIBObjectType mIBObjectType, DOMElement dOMElement) {
        ValueConverter valueConverter;
        MIBTextualConvention mIBTextualConvention;
        Variable variable;
        String string = dOMElement.attributeValue("type");
        if ("OCTET STRING.16".equals(string)) {
            variable = OctetString.fromHexString(dOMElement.getTextTrim());
        } else {
            if ("nil".equals(string)) {
                return null;
            }
            if (mIBObjectType != null) {
                mIBTextualConvention = this._$436.getEffectiveSyntax(mIBObjectType.getSyntax());
                valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
                variable = valueConverter.fromString(dOMElement.getText());
            } else {
                int n = AbstractVariable.getSyntaxFromString(dOMElement.attributeValue("type"));
                variable = AbstractVariable.createFromSyntax(n);
                valueConverter = new ValueConverter(variable.getClass());
                variable = valueConverter.fromString(dOMElement.getText());
            }
        }
        if (mIBObjectType != null && !(valueConverter = new ValueConverter(mIBObjectType, (mIBTextualConvention = this._$436.getEffectiveSyntax(mIBObjectType.getSyntax())).getSyntax(), mIBTextualConvention.getDisplayHint())).isSyntaxCompatible(variable.getSyntax())) {
            _$1141.warn((Serializable)((Object)("Object type mismatch '" + mIBObjectType.getSyntax().getSyntax() + "' does not match '" + variable.getSyntaxString() + "'")));
            throw new IllegalArgumentException("Type mismatch");
        }
        return variable;
    }

    public void writeConfig(FileOutputStream fileOutputStream) throws UnsupportedEncodingException, IOException {
        DOMDocument dOMDocument = new DOMDocument();
        DOMElement dOMElement = new DOMElement("config");
        DOMAttribute dOMAttribute = new DOMAttribute(new QName("xmlns:xsi"), "http://www.w3.org/2001/XMLSchema-instance");
        dOMElement.add(dOMAttribute);
        DOMAttribute dOMAttribute2 = new DOMAttribute(new QName("xsi:noNamespaceSchemaLocation"), "MIBConfig.xsd");
        dOMElement.add(dOMAttribute2);
        dOMDocument.setRootElement(dOMElement);
        for (int i = 0; i < this._$15826.length; ++i) {
            MOServer mOServer = this._$15826[i];
            Iterator<Map.Entry<MOScope, ManagedObject>> iterator = mOServer.iterator();
            while (iterator.hasNext()) {
                Serializable serializable;
                Map.Entry<MOScope, ManagedObject> entry = iterator.next();
                ManagedObject managedObject = entry.getValue();
                if (!(managedObject instanceof MOScalar) && !(managedObject instanceof MOTable)) continue;
                OctetString[] octetStringArray = mOServer.getRegisteredContexts(managedObject);
                DOMElement dOMElement2 = new DOMElement("object");
                dOMElement.add(dOMElement2);
                for (int j = 0; j < octetStringArray.length; ++j) {
                    if (octetStringArray[i] == null) continue;
                    serializable = new DOMElement("context");
                    serializable.setText(octetStringArray[j].toString());
                    dOMElement2.add((Element)((Object)serializable));
                }
                try {
                    MOTable mOTable;
                    Object object;
                    Pair pair = this._$436.getSplittedObjectID(new ObjectID(managedObject.getScope().getLowerBound().getValue()));
                    serializable = (ObjectID)pair.first;
                    ObjectID objectID = (ObjectID)pair.second;
                    MIBObjectType mIBObjectType = null;
                    if (objectID != null && (mIBObjectType = this._$436.getObjectType((ObjectID)serializable)) != null) {
                        dOMElement2.setAttribute("name", mIBObjectType.getName());
                        object = this._$436.getModuleName(mIBObjectType.getModuleID());
                        if (object != null) {
                            dOMElement2.setAttribute("module", (String)object);
                        }
                    }
                    dOMElement2.setAttribute("oid", managedObject.getScope().getLowerBound().toString());
                    if (managedObject instanceof MOScalar) {
                        object = new DOMElement("scalar");
                        mOTable = ((MOScalar)managedObject).getValue();
                        this._$24202((Variable)((Object)mOTable), mIBObjectType, (DOMElement)object);
                        dOMElement2.add((Element)object);
                        continue;
                    }
                    if (!(managedObject instanceof MOTable)) continue;
                    object = null;
                    mOTable = (MOTable)managedObject;
                    Vector vector = null;
                    Vector vector2 = null;
                    if (mIBObjectType != null) {
                        object = this._$436.getTableEntry(mIBObjectType);
                        vector = this._$436.getColumnarObjectsOfTable((MIBObjectType)object, true, false);
                        vector2 = this._$436.getColumnarObjectsOfTable((MIBObjectType)object, false, true);
                    }
                    Iterator iterator2 = mOTable.getModel().iterator();
                    while (iterator2.hasNext()) {
                        DOMElement dOMElement3 = new DOMElement("row");
                        dOMElement2.add(dOMElement3);
                        MOTableRow mOTableRow = (MOTableRow)iterator2.next();
                        dOMElement3.setAttribute("index", mOTableRow.getIndex().toString());
                        if (vector != null) {
                            Variable[] variableArray = mOTable.getIndexDef().getIndexValues(mOTableRow.getIndex());
                            for (int j = 0; j < variableArray.length; ++j) {
                                DOMElement dOMElement4 = new DOMElement("i");
                                dOMElement3.add(dOMElement4);
                                this._$24202(variableArray[j], vector != null && j < vector.size() ? (MIBObjectType)vector.get(j) : null, dOMElement4);
                            }
                        }
                        for (int j = 0; j < mOTableRow.size(); ++j) {
                            DOMElement dOMElement5 = new DOMElement("c");
                            this._$24202(mOTableRow.getValue(j), vector2 != null && j < vector2.size() ? (MIBObjectType)vector2.get(j) : null, dOMElement5);
                            dOMElement3.add(dOMElement5);
                        }
                    }
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                }
            }
        }
        XMLWriter xMLWriter = new XMLWriter(fileOutputStream, new OutputFormat(" ", true));
        xMLWriter.write(dOMDocument);
        xMLWriter.flush();
    }

    private void _$24202(Variable variable, MIBObjectType mIBObjectType, DOMElement dOMElement) {
        if (variable == null) {
            dOMElement.setAttribute("type", "nil");
            return;
        }
        ValueConverter valueConverter = new ValueConverter(variable.getClass());
        if (mIBObjectType != null) {
            MIBTextualConvention mIBTextualConvention = this._$436.getEffectiveSyntax(mIBObjectType.getSyntax());
            valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        dOMElement.setText(valueConverter.toNative(variable).toString());
    }
}

