/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro;

import com.agentpp.agenpro.AgenProFrame;
import com.agentpp.agentgen.AgentGenParser;
import com.agentpp.agentgen.ParseException;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class AttributesPanel
extends JPanel
implements MIBObjectListener,
JCEditCellListener,
JCSelectListener,
JCCellDisplayListener,
ActionListener {
    private static final Logger _$415 = Logger.getLogger("Attributes");
    public static final String[] COLUMNS = new String[]{"Root", "Key", "Value", "Description"};
    public static final int COL_OID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_DESCR = 3;
    public static final int[] COLUMN_WIDTHS = new int[]{20, 20, 15, 30};
    public static final String POPUP_DESCR = "Description";
    public static final String POPUP_DUPLICATE = "Duplicate";
    public static final String POPUP_ENABLE = "Enable";
    public static final String POPUP_DISABLE = "Disable";
    BorderLayout borderLayout1 = new BorderLayout();
    private JCEditableVectorDataSource _$430 = new JCEditableVectorDataSource();
    private TableSorter _$13677;
    private UserConfigFile _$434;
    private MIBRepository _$436;
    private JCCellStyle _$18175;
    private ObjectID _$18176;
    private JPanel _$18177 = new JPanel();
    private JButton _$18178 = new JButton();
    private JButton _$10680 = new JButton();
    private VerticalFlowLayout _$11920 = new VerticalFlowLayout();
    Border border1;
    Border border2;
    JPanel jPanelCenter = new JPanel();
    private JButton _$14330 = new JButton();
    private JButton _$14329 = new JButton();
    private PopupListTable _$399 = new ExtendedListTable(){

        public boolean isPopupAllowed(int n, int n2) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            int n3 = TableUtils.getFirstSelectedRow(AttributesPanel.this._$399);
            if (n3 >= 0 && AttributesPanel.this._$399.getDataView().getTableDataItem(n3, 3) != null) {
                tablePopupMenu.getComponent(0).setEnabled(true);
            } else {
                tablePopupMenu.getComponent(0).setEnabled(false);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column == -1) {
                try {
                    if (jCCellPosition.row >= 0) {
                        return AttributesPanel.this._$430.getTableRowLabel(jCCellPosition.row).toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            try {
                return AttributesPanel.this._$430.getTableDataItem(jCCellPosition.row, jCCellPosition.column).toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    BorderLayout borderLayout2 = new BorderLayout();
    JButton jButtonRemoveAll = new JButton();
    private boolean _$11844 = false;
    private JButton _$18179 = new JButton();

    public AttributesPanel(UserConfigFile userConfigFile, MIBRepository mIBRepository) {
        this._$434 = userConfigFile;
        this._$436 = mIBRepository;
        this._$430.setNumColumns(COLUMNS.length);
        this._$430.setColumnLabels(COLUMNS);
        this._$430.setNumRows(0);
        this._$399.setDataSource(this._$430);
        this._$399.setRowLabelDisplay(true);
        this._$399.setSelectionPolicy(2);
        this._$399.setColumnHidden(3, true);
        this._$399.setFrozenRowPlacement(3);
        this._$399.setRowLabelDisplay(false);
        this._$399.setPopupMenuEnabled(true);
        TablePopupMenu tablePopupMenu = this._$399.getPopupMenu();
        tablePopupMenu.addItem(POPUP_DESCR, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(POPUP_ENABLE, this);
        tablePopupMenu.addItem(POPUP_DISABLE, this);
        this._$13677 = new TableSorter(this._$399, this._$430);
        this._$13677.setFrozenColumn(1);
        this._$13677.addSortColumn(0);
        this._$13677.addSortColumn(1);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$18180();
        ToolTipManager.sharedInstance().registerComponent(this._$399);
        this._$399.addSelectListener(this);
        this._$399.addCellDisplayListener(this);
        this._$399.addEditCellListener(this);
        this.updateButtons();
    }

    public AttributesPanel() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            block7: {
                block5: {
                    int n = TableUtils.getFirstSelectedRow(this._$399);
                    if (n < 0) {
                        return;
                    }
                    if (!actionEvent.getActionCommand().equals(POPUP_DESCR)) break block5;
                    String string = (String)this._$430.getTableDataItem(n, 1);
                    String string2 = (String)this._$430.getTableDataItem(n, 3);
                    if (string2 == null) {
                        JOptionPane.showMessageDialog(this, "There is no description for '" + string + "' available!", "Description Not Found", 0);
                    } else {
                        JOptionPane.showMessageDialog(this, string2, string + " Description", 1);
                    }
                    break block6;
                }
                if (!actionEvent.getActionCommand().equals(POPUP_ENABLE)) break block7;
                int[] nArray = TableUtils.getSelectedRows(this._$399);
                for (int i = 0; i < nArray.length; ++i) {
                    this._$430.setTableDataItem("yes", nArray[i], 2);
                }
                break block6;
            }
            if (!actionEvent.getActionCommand().equals(POPUP_DISABLE)) break block6;
            int[] nArray = TableUtils.getSelectedRows(this._$399);
            for (int i = 0; i < nArray.length; ++i) {
                this._$430.setTableDataItem("no", nArray[i], 2);
            }
        }
    }

    private void _$18180() {
        this._$18175 = new JCCellStyle(this._$399.getDefaultCellStyle());
        this._$18175.setEditable(false);
        this._$18175.setBackground(Color.lightGray);
        this._$399.setCellStyle(-997, 0, this._$18175);
        for (int i = 0; i < COLUMNS.length; ++i) {
            this._$399.setPixelWidth(i, 33002);
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this._$18177.setLayout(this._$11920);
        this._$18178.setIcon(AgenProFrame.imageAdd16);
        this._$18178.setToolTipText("Add a new attribute to this MIB object");
        this._$18178.setHorizontalAlignment(2);
        this._$18178.setText("Add");
        this._$18178.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this._$10680.setIcon(AgenProFrame.imageRemove16);
        this._$10680.setToolTipText("Remove selected properties from this MIB object");
        this._$10680.setHorizontalAlignment(2);
        this._$10680.setText("Remove");
        this._$10680.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this._$18177.setBorder(this.border2);
        this.jPanelCenter.setLayout(this.borderLayout2);
        this._$14330.setIcon(AgenProFrame.imageImport16);
        this._$14330.setToolTipText("Import properties from a properties file");
        this._$14330.setHorizontalAlignment(2);
        this._$14330.setText("Import");
        this._$14330.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonImport_actionPerformed(actionEvent);
            }
        });
        this._$14329.setIcon(AgenProFrame.imageExport16);
        this._$14329.setToolTipText("Export properties defined for this node to a properties file");
        this._$14329.setHorizontalAlignment(2);
        this._$14329.setText("Export");
        this._$14329.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonExport_actionPerformed(actionEvent);
            }
        });
        this._$399.setBorder(this.border1);
        this.jButtonRemoveAll.setToolTipText("Removes all properties defined for this node");
        this.jButtonRemoveAll.setIcon(AgenProFrame.imageDelete16);
        this.jButtonRemoveAll.setText("Remove All");
        this.jButtonRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonRemoveAll_actionPerformed(actionEvent);
            }
        });
        this._$18179.setIcon(AgenProFrame.imageProperties16);
        this._$18179.setToolTipText("Read properties from an existing source (implementation) file");
        this._$18179.setText("From Source");
        this._$18179.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonFromSource_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this._$18177, "West");
        this._$18177.add((Component)this._$18178, null);
        this._$18177.add((Component)this._$10680, null);
        this._$18177.add((Component)this.jButtonRemoveAll, null);
        this._$18177.add((Component)this._$14330, null);
        this._$18177.add((Component)this._$14329, null);
        this._$18177.add((Component)this._$18179, null);
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this._$399, "Center");
    }

    public void loadAttributes(ObjectID objectID) {
        this._$430.setNumRows(0);
        this._$399.setRepaintEnabled(false);
        this._$399.setCellStyle(-997, -997, this._$399.getDefaultCellStyle());
        this._$399.setCellStyle(-997, 0, this._$18175);
        if (objectID != null) {
            this._$18186(objectID, false);
            this._$18187(objectID);
        }
        this._$13677.sort();
        this._$399.setRepaintEnabled(true);
        for (int i = this._$399.getDataView().getNumRows() - 1; i >= 0; --i) {
            if (i != 0 && (this._$399.getCellStyle(i - 1, 1).isEditable() || !this._$399.getCellStyle(i, 1).isEditable())) continue;
            this._$399.traverse(i, 1, false, true);
            break;
        }
        this._$11844 = true;
    }

    private boolean _$18188(String string) {
        for (int i = 0; i < this._$430.getNumRows(); ++i) {
            if (!string.equals(this._$430.getTableDataItem(i, 1))) continue;
            return true;
        }
        return false;
    }

    public static Hashtable getAllAttributes(ObjectID objectID, UserConfigFile userConfigFile) {
        if (objectID == null) {
            return new Hashtable();
        }
        String string = objectID.toString();
        Hashtable hashtable = new Hashtable();
        ObjectID objectID2 = new ObjectID("");
        try {
            for (int i = 0; i < objectID.size(); ++i) {
                hashtable.putAll(AttributesPanel.getAttributes(objectID2.toString(), userConfigFile));
                objectID2.append(objectID.getSubIDAsLong(i));
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        hashtable.putAll(AttributesPanel.getAttributes(string, userConfigFile));
        return hashtable;
    }

    public static boolean hasAttributes(String string, UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("agenpro.attributes.key." + string + ".");
        return vector.size() > 0;
    }

    public static Hashtable getAttributes(String string, UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("agenpro.attributes.key." + string + ".");
        Vector vector2 = userConfigFile.getArray("agenpro.attributes.value." + string + ".");
        int n = Math.min(vector.size(), vector2.size());
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.get(i);
            Object e = vector2.get(i);
            if (e == null) continue;
            hashtable.put(string2, e);
        }
        return hashtable;
    }

    public static void putAttribute(String string, String string2, String string3, UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("agenpro.attributes.key." + string + ".");
        Vector vector2 = userConfigFile.getArray("agenpro.attributes.value." + string + ".");
        int n = Math.min(vector.size(), vector2.size());
        while (vector.size() > n) {
            vector.remove(vector.size() - 1);
        }
        while (vector2.size() > n) {
            vector2.remove(vector2.size() - 1);
        }
        int n2 = vector.indexOf(string2);
        if (n2 >= 0) {
            vector2.set(n2, string3);
        } else {
            vector.add(string2);
            vector2.add(string3);
        }
        userConfigFile.putArray("agenpro.attributes.key." + string + ".", vector);
        userConfigFile.putArray("agenpro.attributes.value." + string + ".", vector2);
    }

    private void _$18186(ObjectID objectID, boolean bl) {
        String string = objectID.toString();
        Vector vector = this._$434.getArray("agenpro.attributes.key." + string + ".");
        Vector vector2 = this._$434.getArray("agenpro.attributes.value." + string + ".");
        int n = Math.min(vector.size(), vector2.size());
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.get(i);
            if (this._$18188(string2)) continue;
            Vector<Object> vector3 = new Vector<Object>(4);
            vector3.add(objectID);
            vector3.add(vector.elementAt(i));
            vector3.add(vector2.elementAt(i));
            vector3.add(this._$434.get("agenpro.attributes.descr." + vector.get(i).toString(), null));
            if (bl) {
                this._$430.addRow(0, null, vector3);
                this._$399.setCellStyle(0, -997, this._$18175);
                continue;
            }
            this._$430.addRow(Integer.MAX_VALUE, null, vector3);
        }
        if (n == 0) {
            this._$399.clearSelection();
        }
    }

    private void _$18187(ObjectID objectID) {
        while (objectID.size() > 0) {
            objectID = ObjectID.trim(objectID);
            this._$18186(objectID, true);
        }
    }

    private int _$18191() {
        for (int i = 0; i < this._$430.getNumRows(); ++i) {
            if (!this._$430.getTableDataItem(i, 0).equals(this._$18176)) continue;
            return i;
        }
        return this._$430.getNumRows();
    }

    public void update() {
        this._$430.deleteRows(0, this._$430.getNumRows());
        if (this._$18176 == null) {
            this._$11844 = false;
        } else {
            this.setCurrentOID(this._$18176);
        }
    }

    public void saveAttributes() {
        if (!this._$11844) {
            return;
        }
        String string = this._$18176.toString();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        for (int i = 0; i < this._$430.getNumRows(); ++i) {
            if (!this._$430.getTableDataItem(i, 0).equals(this._$18176)) continue;
            String string2 = (String)this._$430.getTableDataItem(i, 1);
            String string3 = (String)this._$430.getTableDataItem(i, 2);
            if (string3 == null) {
                string3 = "";
            }
            if (string2 == null || string2.trim().length() <= 0) continue;
            vector.add(string2);
            vector2.add(string3);
            if (this._$430.getTableDataItem(i, 3) == null) continue;
            this._$434.put("agenpro.attributes.descr." + string2, (String)this._$430.getTableDataItem(i, 3));
        }
        this._$434.putArray("agenpro.attributes.key." + string + ".", vector);
        this._$434.putArray("agenpro.attributes.value." + string + ".", vector2);
    }

    public void changedMIBObject(MIBObjectEvent mIBObjectEvent) {
        if (mIBObjectEvent.getType() == 0) {
            if (this._$18176 != null) {
                this.saveAttributes();
            }
            if (mIBObjectEvent.getObject() == null) {
                this._$430.deleteRows(0, this._$430.getNumRows());
                this._$18176 = null;
                this._$11844 = false;
            } else {
                this.setCurrentOID(mIBObjectEvent.getObject().getOid());
            }
            this.updateButtons();
        }
    }

    public void setCurrentOID(ObjectID objectID) {
        this._$18176 = objectID;
        this.loadAttributes(objectID);
    }

    public ObjectID getCurrentOID() {
        return this._$18176;
    }

    public boolean addAttribute(String string, String string2, String string3) {
        if (string == null) {
            return false;
        }
        for (int i = this._$18191(); i < this._$430.getNumRows(); ++i) {
            if (!string.equals(this._$430.getTableDataItem(i, 1))) continue;
            return false;
        }
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this._$18176);
        vector.add(string);
        vector.add(string2);
        vector.add(string3);
        this._$430.addRow(Integer.MAX_VALUE, null, vector);
        return true;
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        this.addAttribute("<name>", "<value>", null);
        this._$399.traverse(this._$430.getNumRows() - 1, 1, true, true);
        this.updateButtons();
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        TableUtils.removeSelectedRows(this._$399, this._$430);
        this.updateButtons();
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
        ((JTextField)jCEditCellEvent.getEditingComponent()).selectAll();
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this.updateButtons();
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
        int n = Math.min(jCSelectEvent.getStartRow(), jCSelectEvent.getEndRow());
        if (n < this._$18191()) {
            jCSelectEvent.setCancelled(true);
        }
    }

    public void select(JCSelectEvent jCSelectEvent) {
        int n;
        if (jCSelectEvent.getAction() == 2 && (n = Math.min(jCSelectEvent.getStartRow(), jCSelectEvent.getEndRow())) < this._$18191()) {
            jCSelectEvent.setCancelled(true);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this._$18176 == null) {
            this._$18178.setEnabled(false);
            this._$10680.setEnabled(false);
            this.jButtonRemoveAll.setEnabled(false);
            this._$14330.setEnabled(false);
            this._$14329.setEnabled(false);
        } else {
            this._$18178.setEnabled(true);
            this._$14330.setEnabled(true);
            this._$10680.setEnabled(TableUtils.getFirstSelectedRow(this._$399) >= 0);
            this.jButtonRemoveAll.setEnabled(this._$430.getNumRows() > 0);
            this._$14329.setEnabled(this._$430.getNumRows() > 0);
        }
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() instanceof ObjectID) {
            ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
            String string = this._$436.getObjectName(objectID);
            if (string == null) {
                string = this._$436.getPathSuffix(objectID);
            }
            if (string != null) {
                jCCellDisplayEvent.setDisplayData(string);
            }
        }
    }

    public void importAttributes(String string) {
        UserConfigFile userConfigFile = new UserConfigFile();
        userConfigFile.setConfigFile(string);
        userConfigFile.read();
        Enumeration<?> enumeration = userConfigFile.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith("agenpro.")) continue;
            String string3 = userConfigFile.properties.getProperty(string2);
            String string4 = userConfigFile.properties.getProperty("agenpro.attributes.descr." + string2);
            this.addAttribute(string2, string3, string4);
        }
    }

    public void exportAttributes(String string) {
        UserConfigFile userConfigFile = new UserConfigFile();
        userConfigFile.setConfigFile(string);
        for (int i = 0; i < this._$430.getNumRows(); ++i) {
            String string2 = (String)this._$430.getTableDataItem(i, 1);
            String string3 = (String)this._$430.getTableDataItem(i, 2);
            userConfigFile.properties.setProperty(string2, string3);
            if (this._$430.getTableDataItem(i, 3) == null) continue;
            userConfigFile.properties.setProperty("agenpro.attributes.descr." + string2, (String)this._$430.getTableDataItem(i, 3));
        }
        userConfigFile.write();
    }

    void jButtonImport_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$434.get("agenpro.PropertiesDirectory", ""));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._$434.put("agenpro.PropertiesDirectory", jFileChooser.getSelectedFile().getParent());
            this.importAttributes(jFileChooser.getSelectedFile().getPath());
        }
    }

    void jButtonExport_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$434.get("agenpro.PropertiesDirectory", ""));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showSaveDialog(this) == 0) {
            this._$434.put("agenpro.PropertiesDirectory", jFileChooser.getSelectedFile().getParent());
            this.exportAttributes(jFileChooser.getSelectedFile().getPath());
        }
    }

    void jButtonRemoveAll_actionPerformed(ActionEvent actionEvent) {
        int n = this._$18191();
        while (this._$430.getNumRows() > n) {
            this._$430.deleteRows(n, 1);
        }
    }

    public void setInitialized(boolean bl) {
        this._$11844 = bl;
    }

    public boolean isInitialized() {
        return this._$11844;
    }

    void jButtonFromSource_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$434.get("agenpro.InputDir", ""));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                int n = 0;
                FileInputStream fileInputStream = new FileInputStream(jFileChooser.getSelectedFile());
                AgentGenParser agentGenParser = new AgentGenParser(fileInputStream);
                AgentGenParser.userCode = new Hashtable();
                agentGenParser.translation_unit();
                Hashtable hashtable = AgentGenParser.userCode;
                for (String string : hashtable.keySet()) {
                    int n2 = string.indexOf("::");
                    if (n2 <= 0) continue;
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 2);
                    ObjectID objectID = this._$436.getObjectID(string2);
                    if (objectID == null) {
                        ++n;
                        _$415.error("Object name '" + string2 + "' could not be resolved with loaded MIB modules");
                        continue;
                    }
                    Vector vector = this._$434.getArray("agenpro.attributes.key." + objectID + ".");
                    vector.add(string3);
                    Vector vector2 = this._$434.getArray("agenpro.attributes.value." + objectID + ".");
                    vector2.add("yes");
                    this._$434.putArray("agenpro.attributes.key." + objectID + ".", vector);
                    this._$434.putArray("agenpro.attributes.value." + objectID + ".", vector2);
                }
                fileInputStream.close();
                if (n > 0) {
                    String[] stringArray = new String[]{"" + n + " warnings were encountered during property extraction from", jFileChooser.getSelectedFile().getPath() + "!" + "Please see the warnings in the category 'Properties' of the log for details."};
                    JOptionPane.showMessageDialog(this, stringArray, "Property Extraction Warnings", 2);
                }
            }
            catch (ParseException parseException) {
                String[] stringArray = new String[]{"Could not parse file '" + jFileChooser.getSelectedFile().getPath() + "':", parseException.getMessage()};
                JOptionPane.showMessageDialog(this, stringArray, "File Parse Error", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "File not found: " + jFileChooser.getSelectedFile().getPath(), "File Open Error", 0);
            }
        }
    }

    public static void removeAllAttributes(String string, UserConfigFile userConfigFile) {
        String string2 = "agenpro.attributes.key." + string + ".";
        Iterator<Map.Entry<Object, Object>> iterator = userConfigFile.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string3 = (String)entry.getKey();
            if (!string3.startsWith(string2)) continue;
            iterator.remove();
        }
    }
}

